/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rest;

import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.rest.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ExecutorUtil;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.uri.UriComponent;

public abstract class AbstractRestClient
implements RestClient {
    private static final long TTL = 24L;
    private static final long IDLE_TIME = 40000L;
    private static final String TOKEN_KEY = "tokenKey";
    private final Client client;
    private final WebTarget target;
    private PoolingHttpClientConnectionManager pool;
    private ScheduledExecutorService cleanExecutor;
    private final ThreadLocal<String> authContext = new InheritableThreadLocal<String>();

    public AbstractRestClient(String url, int timeout) {
        this(url, new ConfigBuilder().configTimeout(timeout).build());
    }

    public AbstractRestClient(String url, String user, String password, int timeout) {
        this(url, new ConfigBuilder().configTimeout(timeout).configUser(user, password).build());
    }

    public AbstractRestClient(String url, int timeout, int maxTotal, int maxPerRoute) {
        this(url, new ConfigBuilder().configTimeout(timeout).configPool(maxTotal, maxPerRoute).build());
    }

    public AbstractRestClient(String url, int timeout, int idleTime, int maxTotal, int maxPerRoute) {
        this(url, new ConfigBuilder().configTimeout(timeout).configIdleTime(idleTime).configPool(maxTotal, maxPerRoute).build());
    }

    public AbstractRestClient(String url, String user, String password, int timeout, int maxTotal, int maxPerRoute) {
        this(url, new ConfigBuilder().configTimeout(timeout).configUser(user, password).configPool(maxTotal, maxPerRoute).build());
    }

    public AbstractRestClient(String url, String user, String password, int timeout, int maxTotal, int maxPerRoute, String trustStoreFile, String trustStorePassword) {
        this(url, new ConfigBuilder().configTimeout(timeout).configUser(user, password).configPool(maxTotal, maxPerRoute).configSSL(trustStoreFile, trustStorePassword).build());
    }

    public AbstractRestClient(String url, String token, int timeout) {
        this(url, new ConfigBuilder().configTimeout(timeout).configToken(token).build());
    }

    public AbstractRestClient(String url, String token, int timeout, int maxTotal, int maxPerRoute) {
        this(url, new ConfigBuilder().configTimeout(timeout).configToken(token).configPool(maxTotal, maxPerRoute).build());
    }

    public AbstractRestClient(String url, String token, int timeout, int maxTotal, int maxPerRoute, String trustStoreFile, String trustStorePassword) {
        this(url, new ConfigBuilder().configTimeout(timeout).configToken(token).configPool(maxTotal, maxPerRoute).configSSL(trustStoreFile, trustStorePassword).build());
    }

    public AbstractRestClient(String url, ClientConfig config) {
        AbstractRestClient.configConnectionManager(url, config);
        this.client = JerseyClientBuilder.newClient((Configuration)config);
        this.client.register(GZipEncoder.class);
        this.target = this.client.target(url);
        this.pool = (PoolingHttpClientConnectionManager)config.getProperty("jersey.config.apache.client.connectionManager");
        if (this.pool != null) {
            this.cleanExecutor = ExecutorUtil.newScheduledThreadPool("conn-clean-worker-%d");
            Number idleTimeProp = (Number)config.getProperty("idleTime");
            long idleTime = idleTimeProp == null ? 40000L : idleTimeProp.longValue();
            long checkPeriod = idleTime / 2L;
            this.cleanExecutor.scheduleWithFixedDelay(() -> {
                PoolStats stats = this.pool.getTotalStats();
                int using = stats.getLeased() + stats.getPending();
                if (using > 0) {
                    return;
                }
                this.pool.closeIdleConnections(idleTime, TimeUnit.MILLISECONDS);
                this.pool.closeExpiredConnections();
            }, checkPeriod, checkPeriod, TimeUnit.MILLISECONDS);
        }
    }

    protected abstract void checkStatus(Response var1, Response.Status ... var2);

    protected Response request(Callable<Response> method) {
        try {
            return method.call();
        }
        catch (Exception e) {
            throw new ClientException("Failed to do request", e);
        }
    }

    @Override
    public RestResult post(String path, Object object) {
        return this.post(path, object, null, null);
    }

    @Override
    public RestResult post(String path, Object object, MultivaluedMap<String, Object> headers) {
        return this.post(path, object, headers, null);
    }

    @Override
    public RestResult post(String path, Object object, Map<String, Object> params) {
        return this.post(path, object, null, params);
    }

    @Override
    public RestResult post(String path, Object object, MultivaluedMap<String, Object> headers, Map<String, Object> params) {
        Pair<Invocation.Builder, Entity<?>> pair = this.buildRequest(path, null, object, headers, params);
        Response response = this.request(() -> ((Invocation.Builder)pair.getLeft()).post((Entity)pair.getRight()));
        this.checkStatus(response, Response.Status.CREATED, Response.Status.OK, Response.Status.ACCEPTED);
        return new RestResult(response);
    }

    @Override
    public RestResult put(String path, String id, Object object) {
        return this.put(path, id, object, (Map<String, Object>)ImmutableMap.of());
    }

    @Override
    public RestResult put(String path, String id, Object object, MultivaluedMap<String, Object> headers) {
        return this.put(path, id, object, headers, null);
    }

    @Override
    public RestResult put(String path, String id, Object object, Map<String, Object> params) {
        return this.put(path, id, object, null, params);
    }

    @Override
    public RestResult put(String path, String id, Object object, MultivaluedMap<String, Object> headers, Map<String, Object> params) {
        Pair<Invocation.Builder, Entity<?>> pair = this.buildRequest(path, id, object, headers, params);
        Response response = this.request(() -> ((Invocation.Builder)pair.getLeft()).put((Entity)pair.getRight()));
        this.checkStatus(response, Response.Status.OK, Response.Status.ACCEPTED);
        return new RestResult(response);
    }

    @Override
    public RestResult get(String path) {
        return this.get(path, null, (Map<String, Object>)ImmutableMap.of());
    }

    @Override
    public RestResult get(String path, Map<String, Object> params) {
        return this.get(path, null, params);
    }

    @Override
    public RestResult get(String path, String id) {
        return this.get(path, id, (Map<String, Object>)ImmutableMap.of());
    }

    private RestResult get(String path, String id, Map<String, Object> params) {
        Ref target = Refs.of((Object)this.target);
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof Collection) {
                for (Object i : (Collection)value) {
                    target.set((Object)((WebTarget)target.get()).queryParam(key, new Object[]{i}));
                }
                continue;
            }
            target.set((Object)((WebTarget)target.get()).queryParam(key, new Object[]{value}));
        }
        Response response = this.request(() -> {
            WebTarget webTarget = (WebTarget)target.get();
            Invocation.Builder builder = id == null ? webTarget.path(path).request() : webTarget.path(path).path(AbstractRestClient.encode(id)).request();
            this.attachAuthToRequest(builder);
            return builder.get();
        });
        this.checkStatus(response, Response.Status.OK);
        return new RestResult(response);
    }

    @Override
    public RestResult delete(String path, Map<String, Object> params) {
        return this.delete(path, null, params);
    }

    @Override
    public RestResult delete(String path, String id) {
        return this.delete(path, id, (Map<String, Object>)ImmutableMap.of());
    }

    private RestResult delete(String path, String id, Map<String, Object> params) {
        Ref target = Refs.of((Object)this.target);
        for (String key : params.keySet()) {
            target.set((Object)((WebTarget)target.get()).queryParam(key, new Object[]{params.get(key)}));
        }
        Response response = this.request(() -> {
            WebTarget webTarget = (WebTarget)target.get();
            Invocation.Builder builder = id == null ? webTarget.path(path).request() : webTarget.path(path).path(AbstractRestClient.encode(id)).request();
            this.attachAuthToRequest(builder);
            return builder.delete();
        });
        this.checkStatus(response, Response.Status.NO_CONTENT, Response.Status.ACCEPTED);
        return new RestResult(response);
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.close();
            this.cleanExecutor.shutdownNow();
        }
        this.client.close();
    }

    public void setAuthContext(String auth) {
        this.authContext.set(auth);
    }

    public void resetAuthContext() {
        this.authContext.remove();
    }

    public String getAuthContext() {
        return this.authContext.get();
    }

    private void attachAuthToRequest(Invocation.Builder builder) {
        String auth = this.getAuthContext();
        if (StringUtils.isNotEmpty((String)auth)) {
            builder.header("Authorization", (Object)auth);
        }
    }

    private Pair<Invocation.Builder, Entity<?>> buildRequest(String path, String id, Object object, MultivaluedMap<String, Object> headers, Map<String, Object> params) {
        Entity entity;
        WebTarget target = this.target;
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> param : params.entrySet()) {
                target = target.queryParam(param.getKey(), new Object[]{param.getValue()});
            }
        }
        Invocation.Builder builder = id == null ? target.path(path).request() : target.path(path).path(AbstractRestClient.encode(id)).request();
        String encoding = null;
        if (headers != null && !headers.isEmpty()) {
            builder = builder.headers(headers);
            encoding = (String)headers.getFirst((Object)"Content-Encoding");
        }
        this.attachAuthToRequest(builder);
        MediaType customContentType = AbstractRestClient.parseCustomContentType(headers);
        if (encoding == null) {
            entity = Entity.entity((Object)object, (MediaType)customContentType);
        } else {
            Variant variant = new Variant(customContentType, (String)null, encoding);
            entity = Entity.entity((Object)object, (Variant)variant);
        }
        return Pair.of((Object)builder, (Object)entity);
    }

    private static MediaType parseCustomContentType(MultivaluedMap<String, Object> headers) {
        String customContentType = null;
        if (MapUtils.isNotEmpty(headers) && headers.get((Object)"Content-Type") != null) {
            List contentTypeObj = (List)headers.get((Object)"Content-Type");
            if (contentTypeObj != null && !contentTypeObj.isEmpty()) {
                customContentType = contentTypeObj.get(0).toString();
            }
            return MediaType.valueOf(customContentType);
        }
        return MediaType.APPLICATION_JSON_TYPE;
    }

    private static void configConnectionManager(String url, ClientConfig conf) {
        PoolingHttpClientConnectionManager pool = AbstractRestClient.connectionManager(url, conf);
        Object maxTotal = conf.getProperty("maxTotal");
        Object maxPerRoute = conf.getProperty("maxPerRoute");
        if (maxTotal != null) {
            pool.setMaxTotal(((Integer)maxTotal).intValue());
        }
        if (maxPerRoute != null) {
            pool.setDefaultMaxPerRoute(((Integer)maxPerRoute).intValue());
        }
        conf.property("jersey.config.apache.client.connectionManager", (Object)pool);
        conf.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
    }

    private static PoolingHttpClientConnectionManager connectionManager(String url, ClientConfig conf) {
        String protocol = (String)conf.getProperty("protocol");
        if (protocol == null || "http".equals(protocol)) {
            return new PoolingHttpClientConnectionManager(24L, TimeUnit.HOURS);
        }
        assert ("https".equals(protocol));
        String trustStoreFile = (String)conf.getProperty("trustStoreFile");
        E.checkArgument(trustStoreFile != null && !trustStoreFile.isEmpty(), "The trust store file must be set when use https", new Object[0]);
        String trustStorePass = (String)conf.getProperty("trustStorePassword");
        E.checkArgument(trustStorePass != null, "The trust store password must be set when use https", new Object[0]);
        SSLContext context = SslConfigurator.newInstance().trustStoreFile(trustStoreFile).trustStorePassword(trustStorePass).securityProtocol("SSL").createSSLContext();
        TrustManager[] trustAllManager = NoCheckTrustManager.create();
        try {
            context.init(null, trustAllManager, new SecureRandom());
        }
        catch (KeyManagementException e) {
            throw new ClientException("Failed to init security management", e);
        }
        HostNameVerifier verifier = new HostNameVerifier(url);
        PlainConnectionSocketFactory httpSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory httpsSocketFactory = new SSLConnectionSocketFactory(context, (HostnameVerifier)verifier);
        Registry registry = RegistryBuilder.create().register("http", (Object)httpSocketFactory).register("https", (Object)httpsSocketFactory).build();
        return new PoolingHttpClientConnectionManager(registry, null, null, null, 24L, TimeUnit.HOURS);
    }

    public static String encode(String raw) {
        return UriComponent.encode((String)raw, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT);
    }

    public static class BearerRequestFilter
    implements ClientRequestFilter {
        public void filter(ClientRequestContext context) {
            String token = context.getClient().getConfiguration().getProperty(AbstractRestClient.TOKEN_KEY).toString();
            context.getHeaders().add((Object)"Authorization", (Object)("Bearer " + token));
        }
    }

    private static class ConfigBuilder {
        private final ClientConfig config = new ClientConfig();

        ConfigBuilder() {
        }

        public ConfigBuilder configTimeout(int timeout) {
            this.config.property("jersey.config.client.connectTimeout", (Object)timeout);
            this.config.property("jersey.config.client.readTimeout", (Object)timeout);
            return this;
        }

        public ConfigBuilder configUser(String username, String password) {
            this.config.register((Object)HttpAuthenticationFeature.basic((String)username, (String)password));
            return this;
        }

        public ConfigBuilder configToken(String token) {
            this.config.property(AbstractRestClient.TOKEN_KEY, (Object)token);
            this.config.register(BearerRequestFilter.class);
            return this;
        }

        public ConfigBuilder configPool(int maxTotal, int maxPerRoute) {
            this.config.property("maxTotal", (Object)maxTotal);
            this.config.property("maxPerRoute", (Object)maxPerRoute);
            return this;
        }

        public ConfigBuilder configIdleTime(int idleTime) {
            this.config.property("idleTime", (Object)idleTime);
            return this;
        }

        public ConfigBuilder configSSL(String trustStoreFile, String trustStorePassword) {
            if (trustStoreFile == null || trustStoreFile.isEmpty() || trustStorePassword == null) {
                this.config.property("protocol", (Object)"http");
            } else {
                this.config.property("protocol", (Object)"https");
            }
            this.config.property("trustStoreFile", (Object)trustStoreFile);
            this.config.property("trustStorePassword", (Object)trustStorePassword);
            return this;
        }

        public ClientConfig build() {
            return this.config;
        }
    }

    private static class NoCheckTrustManager
    implements X509TrustManager {
        private NoCheckTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public static TrustManager[] create() {
            return new TrustManager[]{new NoCheckTrustManager()};
        }
    }

    public static class HostNameVerifier
    implements HostnameVerifier {
        private final String url;

        public HostNameVerifier(String url) {
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            this.url = url = URI.create(url).getHost();
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (!this.url.isEmpty() && this.url.endsWith(hostname)) {
                return true;
            }
            HostnameVerifier verifier = HttpsURLConnection.getDefaultHostnameVerifier();
            return verifier.verify(hostname, session);
        }
    }
}

