/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.http;

import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.RpcConstants;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.server.http.AbstractHttpServerTask;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

public class Http1ServerTask
extends AbstractHttpServerTask {
    protected final boolean keepAlive;

    public Http1ServerTask(HttpServerHandler serverHandler, SofaRequest request, ChannelHandlerContext ctx, boolean keepAlive) {
        super(serverHandler, request, ctx);
        this.keepAlive = keepAlive;
    }

    @Override
    protected void sendAppResponse(HttpResponseStatus status, ByteBuf data) {
        this.sendHttp1Response0(status, false, data);
    }

    @Override
    protected void sendAppError(HttpResponseStatus status, ByteBuf data) {
        this.sendHttp1Response0(status, true, data);
    }

    @Override
    protected void sendRpcError(HttpResponseStatus status, ByteBuf data) {
        this.sendHttp1Response0(status, true, data);
    }

    protected void sendHttp1Response0(HttpResponseStatus status, boolean error, ByteBuf content) {
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        HttpHeaders headers = httpResponse.headers();
        headers.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, httpResponse.content().readableBytes());
        if (this.request.getSerializeType() > 0) {
            String serialization = SerializerFactory.getAliasByCode(this.request.getSerializeType());
            headers.set("sofa_head_serialize_type", (Object)serialization);
        } else {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("text/plain; charset=" + RpcConstants.DEFAULT_CHARSET.displayName()));
        }
        if (error) {
            headers.set("sofa_head_response_error", (Object)"true");
        }
        if (!this.keepAlive) {
            this.ctx.write((Object)httpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            this.ctx.write((Object)httpResponse);
        }
    }
}

