/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.lb;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractLoadBalancer;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.List;
import java.util.Random;

@Extension(value="random")
public class RandomLoadBalancer
extends AbstractLoadBalancer {
    private final Random random = new Random();

    public RandomLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public ProviderInfo doSelect(SofaRequest invocation, List<ProviderInfo> providerInfos) {
        ProviderInfo providerInfo = null;
        int size = providerInfos.size();
        int totalWeight = 0;
        boolean isWeightSame = true;
        for (int i = 0; i < size; ++i) {
            int weight = this.getWeight(providerInfos.get(i));
            totalWeight += weight;
            if (!isWeightSame || i <= 0 || weight == this.getWeight(providerInfos.get(i - 1))) continue;
            isWeightSame = false;
        }
        if (totalWeight > 0 && !isWeightSame) {
            int offset = this.random.nextInt(totalWeight);
            for (int i = 0; i < size; ++i) {
                if ((offset -= this.getWeight(providerInfos.get(i))) >= 0) continue;
                providerInfo = providerInfos.get(i);
                break;
            }
        } else {
            providerInfo = providerInfos.get(this.random.nextInt(size));
        }
        return providerInfo;
    }
}

