/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader;

import org.apache.hugegraph.loader.constant.AutoCloseableIterator;
import org.apache.hugegraph.loader.exception.InitException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.reader.file.LocalFileReader;
import org.apache.hugegraph.loader.reader.hdfs.HDFSFileReader;
import org.apache.hugegraph.loader.reader.jdbc.JDBCReader;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.hdfs.HDFSSource;
import org.apache.hugegraph.loader.source.jdbc.JDBCSource;

public interface InputReader
extends AutoCloseableIterator<Line> {
    public void init(LoadContext var1, InputStruct var2) throws InitException;

    public void confirmOffset();

    @Override
    public void close();

    public static InputReader create(InputSource source) {
        switch (source.type()) {
            case FILE: {
                return new LocalFileReader((FileSource)source);
            }
            case HDFS: {
                return new HDFSFileReader((HDFSSource)source);
            }
            case JDBC: {
                return new JDBCReader((JDBCSource)source);
            }
        }
        throw new AssertionError((Object)String.format("Unsupported input source '%s'", new Object[]{source.type()}));
    }
}

