/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.hgkvfile.builder;

import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.store.KvEntryFileWriter;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvDir;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvDirImpl;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.HgkvFileBuilder;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.HgkvFileBuilderImpl;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class HgkvDirBuilderImpl
implements KvEntryFileWriter {
    private final Config config;
    private final long maxEntriesBytes;
    private final HgkvDir dir;
    private int segmentId;
    private HgkvFileBuilder segmentBuilder;
    private boolean buildFinished;

    public HgkvDirBuilderImpl(Config config, String path) {
        try {
            this.config = config;
            this.maxEntriesBytes = (Long)config.get((TypedOption)ComputerOptions.HGKV_MAX_FILE_SIZE);
            this.dir = HgkvDirImpl.create(path);
            this.segmentId = 0;
            this.segmentBuilder = this.nextSegmentBuilder(config, this.dir, ++this.segmentId);
            this.buildFinished = false;
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void write(KvEntry entry) throws IOException {
        E.checkState((!this.buildFinished ? 1 : 0) != 0, (String)"Failed to write entry, builder is finished", (Object[])new Object[0]);
        E.checkArgument((entry != null && entry.key() != null && entry.value() != null ? 1 : 0) != 0, (String)"Parameter entry can't be empty", (Object[])new Object[0]);
        long entrySize = this.segmentBuilder.sizeOfEntry(entry);
        long segmentSize = this.segmentBuilder.dataLength();
        if (entrySize + segmentSize > this.maxEntriesBytes) {
            this.segmentBuilder = this.nextSegmentBuilder(this.config, this.dir, ++this.segmentId);
        }
        this.segmentBuilder.add(entry);
    }

    @Override
    public void finish() throws IOException {
        if (this.buildFinished) {
            return;
        }
        this.segmentBuilder.finish();
        this.buildFinished = true;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    private HgkvFileBuilder nextSegmentBuilder(Config config, HgkvDir dir, int segmentId) throws IOException {
        if (this.segmentBuilder != null) {
            this.segmentBuilder.finish();
        }
        String fileName = StringUtils.join((Object[])new String[]{"hgkv_", String.valueOf(segmentId), ".hgkv"});
        String path = Paths.get(dir.path(), fileName).toString();
        return new HgkvFileBuilderImpl(config, path);
    }
}

