/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.hgkvfile.builder;

import java.io.IOException;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.BlockBuilder;

public class DataBlockBuilderImpl
implements BlockBuilder {
    private final RandomAccessOutput output;
    private long entriesBytes;

    public DataBlockBuilderImpl(RandomAccessOutput output) {
        this.output = output;
        this.entriesBytes = 0L;
    }

    @Override
    public void add(KvEntry entry) throws IOException {
        entry.key().write(this.output);
        entry.value().write(this.output);
        this.entriesBytes += this.sizeOfEntry(entry);
    }

    @Override
    public long sizeOfEntry(KvEntry entry) {
        long keyLength = 4L + entry.key().length();
        long valueLength = 4L + entry.value().length();
        return keyLength + valueLength;
    }

    @Override
    public long size() {
        return this.entriesBytes;
    }

    @Override
    public void finish() {
    }

    @Override
    public void reset() {
        this.entriesBytes = 0L;
    }
}

