/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output;

import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.output.AbstractComputerOutput;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class LimitedLogOutput
extends AbstractComputerOutput {
    private static final Logger LOG = Log.logger(LimitedLogOutput.class);
    private static final String CONF_LIMIT_OUTPUT_PER_PARTITION_KEY = "output.limit_logt_output";
    private static final int CONF_LIMIT_OUTPUT_PER_PARTITION_DEFAULT = 10;
    private int limit;
    private int logged;

    public void init(Config config, int partition) {
        super.init(config, partition);
        this.limit = config.getInt(CONF_LIMIT_OUTPUT_PER_PARTITION_KEY, 10);
        this.logged = 0;
    }

    public void write(Vertex vertex) {
        if (this.logged < this.limit) {
            LOG.info("'{}': '{}'", (Object)vertex.id(), (Object)vertex.value().string());
            ++this.logged;
        }
    }

    public void close() {
        LOG.info("End write back partition {}", (Object)this.partition());
    }
}

