/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.DefaultMaxBytesRecvByteBufAllocator;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.network.ConnectionId;
import org.apache.hugegraph.computer.core.util.StringEncoding;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class TransportUtil {
    private static final Logger LOG = Log.logger(TransportUtil.class);
    private static final long RESOLVE_TIMEOUT = 2000L;

    public static String remoteAddress(Channel channel) {
        if (channel == null || channel.remoteAddress() == null) {
            return null;
        }
        if (channel.remoteAddress() instanceof InetSocketAddress) {
            return TransportUtil.formatAddress((InetSocketAddress)channel.remoteAddress());
        }
        return channel.toString();
    }

    public static ConnectionId remoteConnectionId(Channel channel) {
        if (channel == null || channel.remoteAddress() == null) {
            return null;
        }
        InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
        return ConnectionId.parseConnectionId(address.getHostName(), address.getPort());
    }

    public static InetAddress resolvedAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new ComputerException("Failed to parse address from '%s'", (Throwable)e, new Object[]{host});
        }
    }

    public static InetSocketAddress resolvedSocketAddress(String host, int port) {
        long preResolveHost = System.nanoTime();
        InetSocketAddress resolvedAddress = new InetSocketAddress(host, port);
        long resolveTimeMs = (System.nanoTime() - preResolveHost) / 1000000L;
        if (resolveTimeMs > 2000L || resolvedAddress.isUnresolved()) {
            String status = resolvedAddress.isUnresolved() ? "failed" : "succeed";
            LOG.warn("DNS resolution {} for '{}' took {} ms", new Object[]{status, resolvedAddress, resolveTimeMs});
        }
        return resolvedAddress;
    }

    public static String host(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        if (address != null) {
            return address.getHostAddress();
        }
        return socketAddress.getHostName();
    }

    public static List<String> getLocalIPAddress() {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    ips.add(ip.getHostAddress());
                }
            }
            return ips;
        }
        catch (Exception e) {
            throw new ComputerException("Failed to getLocalIPAddress", (Throwable)e);
        }
    }

    public static String formatAddress(InetSocketAddress socketAddress) {
        E.checkNotNull((Object)socketAddress, (String)"socketAddress");
        InetAddress address = socketAddress.getAddress();
        String host = address != null && !socketAddress.isUnresolved() ? address.getHostAddress() : socketAddress.getHostString();
        return String.format("%s:%s", host, socketAddress.getPort());
    }

    public static String readString(ByteBuf buf) {
        int length = buf.readInt();
        E.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"The length mast be >= 0, but got %s", (Object[])new Object[]{length});
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return StringEncoding.decode(bytes);
    }

    public static void writeString(ByteBuf buf, String value) {
        E.checkArgumentNotNull((Object)value, (String)"value", (Object[])new Object[0]);
        byte[] encoded = StringEncoding.encode(value);
        buf.writeInt(encoded.length);
        buf.writeBytes(encoded);
    }

    public static void setMaxBytesPerRead(Channel channel, int length) {
        DefaultMaxBytesRecvByteBufAllocator recvByteBufAllocator = (DefaultMaxBytesRecvByteBufAllocator)channel.config().getRecvByteBufAllocator();
        if (recvByteBufAllocator.maxBytesPerIndividualRead() != length) {
            recvByteBufAllocator.maxBytesPerReadPair(length, length);
        }
    }
}

