/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network;

import java.net.InetSocketAddress;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.network.MessageHandler;
import org.apache.hugegraph.computer.core.network.connection.ConnectionManager;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class DataServerManager
implements Manager {
    private static final Logger LOG = Log.logger(DataServerManager.class);
    public static final String NAME = "data_server";
    private final ConnectionManager connectionManager;
    private final MessageHandler messageHandler;

    public DataServerManager(ConnectionManager connectionManager, MessageHandler messageHandler) {
        this.connectionManager = connectionManager;
        this.messageHandler = messageHandler;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        this.connectionManager.startServer(config, this.messageHandler);
        LOG.info("DataServerManager initialized with address '{}'", (Object)this.address());
    }

    @Override
    public void close(Config config) {
        InetSocketAddress address = this.address();
        this.connectionManager.shutdownServer();
        LOG.info("DataServerManager closed with address '{}'", (Object)address);
    }

    public InetSocketAddress address() {
        return this.connectionManager.getServer().bindAddress();
    }
}

