/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.util.E;

public class ConnectionId {
    private static final ConcurrentHashMap<String, ConnectionId> CONNECTION_ID_CACHE = new ConcurrentHashMap();
    private final InetSocketAddress address;
    private final int clientIndex;

    public static ConnectionId parseConnectionId(String host, int port) {
        return ConnectionId.parseConnectionId(host, port, 0);
    }

    public static ConnectionId parseConnectionId(String host, int port, int clientIndex) {
        String cacheKey = ConnectionId.buildCacheKey(host, port, clientIndex);
        Function<String, ConnectionId> resolveAddress = key -> {
            InetSocketAddress socketAddress = TransportUtil.resolvedSocketAddress(host, port);
            return new ConnectionId(socketAddress, clientIndex);
        };
        return CONNECTION_ID_CACHE.computeIfAbsent(cacheKey, resolveAddress);
    }

    public ConnectionId(InetSocketAddress address) {
        this(address, 0);
    }

    public ConnectionId(InetSocketAddress address, int clientIndex) {
        E.checkArgument((clientIndex >= 0 ? 1 : 0) != 0, (String)"The clientIndex must be >= 0", (Object[])new Object[0]);
        E.checkArgument((!address.isUnresolved() ? 1 : 0) != 0, (String)"The address must be resolved", (Object[])new Object[0]);
        this.address = address;
        this.clientIndex = clientIndex;
    }

    private static String buildCacheKey(String host, int port, int clientIndex) {
        return host + ":" + port + "[" + clientIndex + "]";
    }

    public InetSocketAddress socketAddress() {
        return this.address;
    }

    public int clientIndex() {
        return this.clientIndex;
    }

    public int hashCode() {
        return this.address.hashCode() + 31 * this.clientIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectionId)) {
            return false;
        }
        ConnectionId other = (ConnectionId)obj;
        return other.socketAddress().equals(this.address) && other.clientIndex() == this.clientIndex;
    }

    public String toString() {
        return String.format("%s[%d]", TransportUtil.formatAddress(this.address), this.clientIndex);
    }
}

