/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.UnsafeBytesOutput;
import org.apache.hugegraph.computer.core.util.CoderUtil;
import org.apache.hugegraph.util.E;

public class OptimizedBytesOutput
implements BytesOutput {
    private final UnsafeBytesOutput out;

    public OptimizedBytesOutput(int size) {
        this(new UnsafeBytesOutput(size));
    }

    public OptimizedBytesOutput(UnsafeBytesOutput out) {
        this.out = out;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.writeVInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.writeVLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    public void writeUTF(String s) throws IOException {
        this.writeString(s);
    }

    public long position() {
        return this.out.position();
    }

    public void seek(long position) throws IOException {
        this.out.seek(position);
    }

    public long skip(long n) throws IOException {
        return this.out.skip(n);
    }

    public void write(RandomAccessInput input, long offset, long length) throws IOException {
        this.out.write(input, offset, length);
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void writeFixedInt(int v) throws IOException {
        this.out.writeFixedInt(v);
    }

    public void writeFixedInt(long position, int v) throws IOException {
        this.out.writeFixedInt(position, v);
    }

    public byte[] buffer() {
        return this.out.buffer();
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }

    private void writeVInt(int value) throws IOException {
        if (value > 0xFFFFFFF || value < 0) {
            this.writeByte(0x80 | value >>> 28 & 0x7F);
        }
        if (value > 0x1FFFFF || value < 0) {
            this.writeByte(0x80 | value >>> 21 & 0x7F);
        }
        if (value > 16383 || value < 0) {
            this.writeByte(0x80 | value >>> 14 & 0x7F);
        }
        if (value > 127 || value < 0) {
            this.writeByte(0x80 | value >>> 7 & 0x7F);
        }
        this.writeByte(value & 0x7F);
    }

    private void writeVLong(long value) throws IOException {
        if (value < 0L) {
            this.writeByte(-127);
        }
        if (value > 0xFFFFFFFFFFFFFFL || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 56) & 0x7F);
        }
        if (value > 0x1FFFFFFFFFFFFL || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 49) & 0x7F);
        }
        if (value > 0x3FFFFFFFFFFL || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 42) & 0x7F);
        }
        if (value > 0x7FFFFFFFFL || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 35) & 0x7F);
        }
        if (value > 0xFFFFFFFL || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 28) & 0x7F);
        }
        if (value > 0x1FFFFFL || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 21) & 0x7F);
        }
        if (value > 16383L || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 14) & 0x7F);
        }
        if (value > 127L || value < 0L) {
            this.writeByte(0x80 | (int)(value >>> 7) & 0x7F);
        }
        this.write((int)value & 0x7F);
    }

    private void writeString(String val) throws IOException {
        this.writeBytes(CoderUtil.encode((String)val));
    }

    private void writeBytes(byte[] bytes) throws IOException {
        E.checkArgument((bytes.length <= 65535 ? 1 : 0) != 0, (String)"The max length of bytes is %s, but got %s", (Object[])new Object[]{65535, bytes.length});
        this.writeVInt(bytes.length);
        this.write(bytes);
    }
}

