/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input;

import java.util.Iterator;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;
import org.apache.hugegraph.computer.core.sender.MessageSendManager;
import org.apache.hugegraph.computer.core.worker.load.LoadService;

public class WorkerInputManager
implements Manager {
    public static final String NAME = "worker_input";
    private final LoadService loadService;
    private final MessageSendManager sendManager;

    public WorkerInputManager(ComputerContext context, MessageSendManager sendManager) {
        this.loadService = new LoadService(context);
        this.sendManager = sendManager;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        this.loadService.init();
        this.sendManager.init(config);
    }

    @Override
    public void close(Config config) {
        this.loadService.close();
        this.sendManager.close(config);
    }

    public void service(InputSplitRpcService rpcService) {
        this.loadService.rpcService(rpcService);
    }

    public void loadGraph() {
        Vertex vertex;
        this.sendManager.startSend(MessageType.VERTEX);
        Iterator<Vertex> iterator = this.loadService.createIteratorFromVertex();
        while (iterator.hasNext()) {
            vertex = iterator.next();
            this.sendManager.sendVertex(vertex);
        }
        this.sendManager.finishSend(MessageType.VERTEX);
        this.sendManager.startSend(MessageType.EDGE);
        iterator = this.loadService.createIteratorFromEdge();
        while (iterator.hasNext()) {
            vertex = iterator.next();
            this.sendManager.sendEdge(vertex);
        }
        this.sendManager.finishSend(MessageType.EDGE);
        this.sendManager.clearBuffer();
    }
}

