/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.compute.input;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.compute.input.ReusablePointer;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.entry.Pointer;

public class MessageInput<T extends Value> {
    private final Config config;
    private final PeekableIterator<KvEntry> messages;
    private final T value;

    public MessageInput(ComputerContext context, PeekableIterator<KvEntry> messages) {
        this.messages = messages == null ? PeekableIterator.emptyIterator() : messages;
        this.config = context.config();
        this.value = (Value)this.config.createObject(ComputerOptions.ALGORITHM_MESSAGE_CLASS);
    }

    public Iterator<T> iterator(ReusablePointer vidPointer) {
        while (this.messages.hasNext()) {
            KvEntry entry = this.messages.peek();
            Pointer key = entry.key();
            int status = vidPointer.compareTo(key);
            if (status < 0) {
                return Collections.emptyIterator();
            }
            if (status == 0) break;
            this.messages.next();
        }
        return new MessageIterator(vidPointer);
    }

    public void close() throws Exception {
        this.messages.close();
    }

    private class MessageIterator
    implements Iterator<T> {
        private boolean valueValid;
        private ReusablePointer vidPointer;

        private MessageIterator(ReusablePointer vidPointer) {
            this.vidPointer = vidPointer;
            this.valueValid = false;
        }

        @Override
        public boolean hasNext() {
            if (this.valueValid) {
                return true;
            }
            if (MessageInput.this.messages.hasNext()) {
                KvEntry entry = MessageInput.this.messages.peek();
                Pointer key = entry.key();
                int status = this.vidPointer.compareTo(key);
                if (status == 0) {
                    MessageInput.this.messages.next();
                    this.valueValid = true;
                    try {
                        BytesInput in = IOFactory.createBytesInput(entry.value().bytes());
                        MessageInput.this.value.read((RandomAccessInput)in);
                    }
                    catch (IOException e) {
                        throw new ComputerException("Can't read value", (Throwable)e);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.valueValid) {
                this.valueValid = false;
                return MessageInput.this.value;
            }
            throw new NoSuchElementException();
        }
    }
}

