/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.io.Writable;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.util.JsonUtil;
import org.apache.hugegraph.util.E;

public class ContainerInfo
implements Readable,
Writable {
    public static final int MASTER_ID = 0;
    private int id;
    private String hostname;
    private int rpcPort;
    private int dataPort;

    public ContainerInfo() {
        this(-1, "", -1, -1);
    }

    public ContainerInfo(int id, String hostname, int rpcPort) {
        this(id, hostname, rpcPort, -1);
    }

    public ContainerInfo(String hostname, int rpcPort, int dataPort) {
        this(-1, hostname, rpcPort, dataPort);
    }

    public ContainerInfo(int id, String hostname, int rpcPort, int dataPort) {
        E.checkArgumentNotNull((Object)hostname, (String)"The hostname can't be null", (Object[])new Object[0]);
        this.id = id;
        this.hostname = hostname;
        this.rpcPort = rpcPort;
        this.dataPort = dataPort;
    }

    public int id() {
        return this.id;
    }

    public void id(int id) {
        this.id = id;
    }

    public String hostname() {
        return this.hostname;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int dataPort() {
        return this.dataPort;
    }

    public String uniqueName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hostname).append(":").append(this.dataPort);
        return sb.toString();
    }

    public void updateAddress(InetSocketAddress address) {
        this.hostname = TransportUtil.host(address);
        this.dataPort = address.getPort();
    }

    public void read(RandomAccessInput in) throws IOException {
        this.id = in.readInt();
        this.hostname = in.readUTF();
        this.rpcPort = in.readInt();
        this.dataPort = in.readInt();
    }

    public void write(RandomAccessOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.hostname);
        out.writeInt(this.rpcPort);
        out.writeInt(this.dataPort);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerInfo)) {
            return false;
        }
        ContainerInfo other = (ContainerInfo)obj;
        return this.id == other.id && this.hostname.equals(other.hostname) && this.rpcPort == other.rpcPort && this.dataPort == other.dataPort;
    }

    public int hashCode() {
        return Integer.hashCode(this.id);
    }

    public String toString() {
        return JsonUtil.toJsonWithClass(this);
    }
}

