/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.bsp;

import org.apache.hugegraph.computer.core.bsp.BspClient;
import org.apache.hugegraph.computer.core.bsp.BspEvent;
import org.apache.hugegraph.computer.core.bsp.EtcdBspClient;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class BspBase {
    private static final Logger LOG = Log.logger(BspBase.class);
    private final Config config;
    private final String jobId;
    private final int workerCount;
    private final long registerTimeout;
    private final long barrierOnMasterTimeout;
    private final long barrierOnWorkersTimeout;
    private final long logInterval;
    private final BspClient bspClient;

    public BspBase(Config config) {
        this.config = config;
        this.jobId = (String)config.get((TypedOption)ComputerOptions.JOB_ID);
        this.workerCount = (Integer)this.config.get((TypedOption)ComputerOptions.JOB_WORKERS_COUNT);
        this.registerTimeout = (Long)this.config.get((TypedOption)ComputerOptions.BSP_REGISTER_TIMEOUT);
        this.barrierOnWorkersTimeout = (Long)this.config.get((TypedOption)ComputerOptions.BSP_WAIT_WORKERS_TIMEOUT);
        this.barrierOnMasterTimeout = (Long)this.config.get((TypedOption)ComputerOptions.BSP_WAIT_MASTER_TIMEOUT);
        this.logInterval = (Long)this.config.get((TypedOption)ComputerOptions.BSP_LOG_INTERVAL);
        this.bspClient = this.init();
    }

    private BspClient init() {
        BspClient bspClient = this.createBspClient();
        bspClient.init(this.jobId);
        LOG.info("Init {} BSP connection to '{}' for job '{}'", new Object[]{bspClient.type(), bspClient.endpoint(), this.jobId});
        return bspClient;
    }

    public void close() {
        this.bspClient.close();
        LOG.info("Closed {} BSP connection '{}' for job '{}'", new Object[]{this.bspClient.type(), this.bspClient.endpoint(), this.jobId});
    }

    public void clean() {
        try {
            this.bspClient().clean();
        }
        catch (Exception e) {
            throw new ComputerException("Failed to clean up the BSP data: %s", (Throwable)e, new Object[]{this.bspClient().endpoint()});
        }
        LOG.info("Cleaned up the BSP data: {}", (Object)this.bspClient().endpoint());
    }

    private BspClient createBspClient() {
        return new EtcdBspClient(this.config);
    }

    protected final BspClient bspClient() {
        return this.bspClient;
    }

    public final int workerCount() {
        return this.workerCount;
    }

    public final long registerTimeout() {
        return this.registerTimeout;
    }

    public final long barrierOnMasterTimeout() {
        return this.barrierOnMasterTimeout;
    }

    public final long barrierOnWorkersTimeout() {
        return this.barrierOnWorkersTimeout;
    }

    public final long logInterval() {
        return this.logInterval;
    }

    protected String constructPath(BspEvent event, Object ... paths) {
        StringBuilder sb = new StringBuilder();
        sb.append(event.name());
        for (Object path : paths) {
            sb.append("/").append(path.toString());
        }
        return sb.toString();
    }
}

