/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.allocator;

import io.netty.util.Recycler;
import java.util.function.Supplier;
import org.apache.hugegraph.computer.core.allocator.Allocator;
import org.apache.hugegraph.computer.core.allocator.Recyclable;
import org.apache.hugegraph.computer.core.allocator.RecycleHandler;
import org.apache.hugegraph.computer.core.allocator.RecyclerReference;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.config.TypedOption;

public final class DefaultAllocator
implements Allocator {
    private final GraphFactory factory;
    private final Recycler<RecyclerReference<Vertex>> vertexRecycler;
    private final Recycler<RecyclerReference<Edge>> edgeRecycler;

    public DefaultAllocator(Config config, GraphFactory factory) {
        this.factory = factory;
        int capacityPerThread = (Integer)config.get((TypedOption)ComputerOptions.ALLOCATOR_MAX_VERTICES_PER_THREAD);
        this.vertexRecycler = this.newRecycler(capacityPerThread, () -> ((GraphFactory)this.factory).createVertex());
        this.edgeRecycler = this.newRecycler(capacityPerThread, () -> ((GraphFactory)this.factory).createEdge());
    }

    private <T extends Recyclable> Recycler<RecyclerReference<T>> newRecycler(int capacityPerThread, final Supplier<T> supplier) {
        return new Recycler<RecyclerReference<T>>(capacityPerThread){

            protected RecyclerReference<T> newObject(Recycler.Handle<RecyclerReference<T>> handle) {
                Recyclable recyclable = (Recyclable)supplier.get();
                return new RecyclerReference(recyclable, new RecycleHandler(handle));
            }
        };
    }

    public RecyclerReference<Vertex> newVertex() {
        return (RecyclerReference)this.vertexRecycler.get();
    }

    public void freeVertex(RecyclerReference<Vertex> reference) {
        reference.close();
    }

    public RecyclerReference<Edge> newEdge() {
        return (RecyclerReference)this.edgeRecycler.get();
    }

    public void freeEdge(RecyclerReference<Edge> reference) {
        reference.close();
    }
}

