/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.code;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiEntityIdCode implements IpmiCode.Code
{
    Unspecified(0, "unspecified"),
    Other(1, "other"),
    Unknown(2, "unknown"),
    Processor(3, "processor"),
    Disk_or_DiskBay(4, "disk or disk bay"),
    Peripheral_Bay(5, "peripheral bay"),
    System_Management_Module(6, "system management module"),
    System_Board(7, "system board"),
    Memory_Module(8, "memory module"),
    Processor_Module(9, "processor module"),
    Power_Supply(10, "power supply"),
    Add_in_Card(11, "add-in card"),
    Front_Panel_Board(12, "front panel board"),
    Back_Panel_Board(13, "back panel board"),
    Power_System_Board(14, "power system board"),
    Drive_Backplane(15, "drive backplane"),
    System_Internal_Expansion_Board(16, "system internal expansion board"),
    Other_System_Board(17, "other system board"),
    Processor_Board(18, "processor board"),
    Power_Unit(19, "power unit / power domain"),
    Power_Module(20, "power module / DC-to-DC converter"),
    Power_Management(21, "power management / power distribution board"),
    Chassis_Back_Panel_Board(22, "chassis back panel board"),
    System_Chassis(23, "system chassis"),
    Sub_Chassis(24, "sub-chassis"),
    Other_Chassis_Board(25, "other chassis board"),
    Disk_Drive(26, "disk drive"),
    Peripheral_Bay_2(27, "Peripheral Bay"),
    Device_Bay(28, "device bay"),
    Fan(29, "fan / cooling device"),
    Cooling_Unit(30, "cooling unit / cooling domain"),
    Cable_or_Interconnect(31, "cable / interconnect"),
    Memory_Device(32, "memory device"),
    System_Management_Software(33, "system management software"),
    System_Firmware(34, "system firmware (e.g. BIOS / EFI)"),
    Operating_System(35, "operating system"),
    System_Bus(36, "system bus"),
    Group(37, "group"),
    Remote_Management_Communication_Device(38, "remote management communication device"),
    External_Environment(39, "external environment"),
    Battery(40, "battery"),
    Processing_Blade(41, "processing blade"),
    Connectivity_Switch(42, "connectivity switch"),
    Processor_Memory_Module(43, "processor memory module"),
    IO_Module(44, "I/O module"),
    Processor_IO_Module(45, "processor I/O module"),
    Management_Controller(46, "management controller"),
    Ipmi_Channel(47, "IPMI channel"),
    PCI_Bus(48, "PCI bus"),
    PCI_Express_Bus(49, "PCI Express bus"),
    SCSI_Bus_Parallel(50, "SCSI bus (parallel)"),
    SATA_SAS_Bus(51, "SATA / SAS bus"),
    Processor_Front_Side_Bus(52, "processor front-side bus"),
    Real_Time_Clock(53, "real-time clock"),
    Air_Inlet(55, "air inlet"),
    Air_Inlet_2(64, "air inlet"),
    Processor_2(65, "processor"),
    System_Board_2(66, "system board");

    private byte code;
    private String description;

    private IpmiEntityIdCode(int code, String description) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.description = description;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

