/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.protocol;

import java.time.Duration;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagCoil;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagDiscreteInput;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagExtendedRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagHoldingRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagInputRegister;
import org.apache.plc4x.java.modbus.readwrite.DataItem;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordRequestItem;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequestItem;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleHoldingRegistersRequest;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcList;

public abstract class ModbusProtocolLogic<T extends ModbusADU>
extends Plc4xProtocolBase<T> {
    protected final DriverType driverType;
    protected Duration requestTimeout;
    protected short unitIdentifier;
    protected PlcTag pingAddress;
    protected RequestTransactionManager tm;
    protected final AtomicInteger transactionIdentifierGenerator = new AtomicInteger(1);
    protected static final int FC_EXTENDED_REGISTERS_GROUP_HEADER_LENGTH = 2;
    protected static final int FC_EXTENDED_REGISTERS_FILE_RECORD_LENGTH = 10000;

    public ModbusProtocolLogic(DriverType driverType) {
        this.driverType = driverType;
    }

    public void close(ConversationContext<T> context) {
    }

    protected void decode(ConversationContext<T> context, T msg) throws Exception {
        super.decode(context, msg);
    }

    protected PlcResponseCode getErrorCode(ModbusPDUError errorResponse) {
        switch (errorResponse.getExceptionCode()) {
            case ILLEGAL_FUNCTION: {
                return PlcResponseCode.UNSUPPORTED;
            }
            case ILLEGAL_DATA_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case ILLEGAL_DATA_VALUE: {
                return PlcResponseCode.INVALID_DATA;
            }
            case SLAVE_DEVICE_FAILURE: {
                return PlcResponseCode.REMOTE_ERROR;
            }
            case ACKNOWLEDGE: {
                return PlcResponseCode.OK;
            }
            case SLAVE_DEVICE_BUSY: {
                return PlcResponseCode.REMOTE_BUSY;
            }
            case NEGATIVE_ACKNOWLEDGE: {
                return PlcResponseCode.REMOTE_ERROR;
            }
            case MEMORY_PARITY_ERROR: {
                return PlcResponseCode.INTERNAL_ERROR;
            }
            case GATEWAY_PATH_UNAVAILABLE: {
                return PlcResponseCode.INTERNAL_ERROR;
            }
            case GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND: {
                return PlcResponseCode.REMOTE_ERROR;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    protected ModbusPDU getReadRequestPdu(PlcTag tag) {
        if (tag instanceof ModbusTagDiscreteInput) {
            ModbusTagDiscreteInput discreteInput = (ModbusTagDiscreteInput)tag;
            return new ModbusPDUReadDiscreteInputsRequest(discreteInput.getAddress(), discreteInput.getNumberOfElements());
        }
        if (tag instanceof ModbusTagCoil) {
            ModbusTagCoil coil = (ModbusTagCoil)tag;
            return new ModbusPDUReadCoilsRequest(coil.getAddress(), coil.getNumberOfElements());
        }
        if (tag instanceof ModbusTagInputRegister) {
            ModbusTagInputRegister inputRegister = (ModbusTagInputRegister)tag;
            return new ModbusPDUReadInputRegistersRequest(inputRegister.getAddress(), Math.max(inputRegister.getLengthWords(), 1));
        }
        if (tag instanceof ModbusTagHoldingRegister) {
            ModbusTagHoldingRegister holdingRegister = (ModbusTagHoldingRegister)tag;
            return new ModbusPDUReadHoldingRegistersRequest(holdingRegister.getAddress(), Math.max(holdingRegister.getLengthWords(), 1));
        }
        if (tag instanceof ModbusTagExtendedRegister) {
            List<ModbusPDUReadFileRecordRequestItem> itemArray;
            ModbusTagExtendedRegister extendedRegister = (ModbusTagExtendedRegister)tag;
            int group1Address = extendedRegister.getAddress() % 10000;
            int group2Address = 0;
            short group1FileNumber = (short)(Math.floor((float)extendedRegister.getAddress() / 10000.0f) + 1.0);
            if (group1Address + extendedRegister.getLengthWords() <= 10000) {
                int group1Quantity = extendedRegister.getLengthWords();
                ModbusPDUReadFileRecordRequestItem group1 = new ModbusPDUReadFileRecordRequestItem(6, group1FileNumber, group1Address, group1Quantity);
                itemArray = Collections.singletonList(group1);
            } else {
                int group1Quantity = 10000 - group1Address;
                int group2Quantity = extendedRegister.getLengthWords() - group1Quantity;
                short group2FileNumber = (short)(group1FileNumber + 1);
                ModbusPDUReadFileRecordRequestItem group1 = new ModbusPDUReadFileRecordRequestItem(6, group1FileNumber, group1Address, group1Quantity);
                ModbusPDUReadFileRecordRequestItem group2 = new ModbusPDUReadFileRecordRequestItem(6, group2FileNumber, group2Address, group2Quantity);
                itemArray = Arrays.asList(group1, group2);
            }
            return new ModbusPDUReadFileRecordRequest(itemArray);
        }
        throw new PlcRuntimeException("Unsupported read tag type " + tag.getClass().getName());
    }

    protected ModbusPDU getWriteRequestPdu(PlcTag tag, PlcValue plcValue) {
        if (tag instanceof ModbusTagCoil) {
            ModbusTagCoil coil = (ModbusTagCoil)tag;
            ModbusPDUWriteMultipleCoilsRequest request = new ModbusPDUWriteMultipleCoilsRequest(coil.getAddress(), coil.getNumberOfElements(), this.fromPlcValue(tag, plcValue));
            if (request.getQuantity() == coil.getNumberOfElements()) {
                return request;
            }
            throw new PlcRuntimeException("Number of requested bytes (" + request.getQuantity() + ") doesn't match number of requested addresses (" + coil.getNumberOfElements() + ")");
        }
        if (tag instanceof ModbusTagHoldingRegister) {
            ModbusTagHoldingRegister holdingRegister = (ModbusTagHoldingRegister)tag;
            ModbusPDUWriteMultipleHoldingRegistersRequest request = new ModbusPDUWriteMultipleHoldingRegistersRequest(holdingRegister.getAddress(), holdingRegister.getLengthWords(), this.fromPlcValue(tag, plcValue));
            if (request.getValue().length == holdingRegister.getLengthWords() * 2) {
                return request;
            }
            throw new PlcRuntimeException("Number of requested values (" + request.getValue().length / 2 + ") doesn't match number of requested addresses (" + holdingRegister.getLengthWords() + ")");
        }
        if (tag instanceof ModbusTagExtendedRegister) {
            List<ModbusPDUWriteFileRecordRequestItem> itemArray;
            ModbusTagExtendedRegister extendedRegister = (ModbusTagExtendedRegister)tag;
            int group1Address = extendedRegister.getAddress() % 10000;
            int group2Address = 0;
            short group1FileNumber = (short)(Math.floor((float)extendedRegister.getAddress() / 10000.0f) + 1.0);
            if (group1Address + extendedRegister.getLengthWords() <= 10000) {
                int group1Quantity = extendedRegister.getLengthWords();
                ModbusPDUWriteFileRecordRequestItem group1 = new ModbusPDUWriteFileRecordRequestItem(6, group1FileNumber, group1Address, this.fromPlcValue(tag, plcValue));
                itemArray = Collections.singletonList(group1);
            } else {
                int group1Quantity = 10000 - group1Address;
                int group2Quantity = extendedRegister.getLengthWords() - group1Quantity;
                short group2FileNumber = (short)(group1FileNumber + 1);
                byte[] plcValue1 = ArrayUtils.subarray((byte[])this.fromPlcValue(tag, plcValue), (int)0, (int)group1Quantity);
                byte[] plcValue2 = ArrayUtils.subarray((byte[])this.fromPlcValue(tag, plcValue), (int)group1Quantity, (int)this.fromPlcValue(tag, plcValue).length);
                ModbusPDUWriteFileRecordRequestItem group1 = new ModbusPDUWriteFileRecordRequestItem(6, group1FileNumber, group1Address, plcValue1);
                ModbusPDUWriteFileRecordRequestItem group2 = new ModbusPDUWriteFileRecordRequestItem(6, group2FileNumber, group2Address, plcValue2);
                itemArray = Arrays.asList(group1, group2);
            }
            return new ModbusPDUWriteFileRecordRequest(itemArray);
        }
        throw new PlcRuntimeException("Unsupported write tag type " + tag.getClass().getName());
    }

    protected PlcValue toPlcValue(ModbusPDU request, ModbusPDU response, ModbusDataType dataType) throws ParseException {
        short tagDataTypeSize = dataType.getDataTypeSize();
        if (request instanceof ModbusPDUReadDiscreteInputsRequest) {
            if (!(response instanceof ModbusPDUReadDiscreteInputsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadDiscreteInputsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadDiscreteInputsRequest req = (ModbusPDUReadDiscreteInputsRequest)request;
            ModbusPDUReadDiscreteInputsResponse resp = (ModbusPDUReadDiscreteInputsResponse)response;
            return this.readCoilBooleanList(req.getQuantity(), resp.getValue());
        }
        if (request instanceof ModbusPDUReadCoilsRequest) {
            if (!(response instanceof ModbusPDUReadCoilsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadCoilsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadCoilsRequest req = (ModbusPDUReadCoilsRequest)request;
            ModbusPDUReadCoilsResponse resp = (ModbusPDUReadCoilsResponse)response;
            return this.readCoilBooleanList(req.getQuantity(), resp.getValue());
        }
        if (request instanceof ModbusPDUReadInputRegistersRequest) {
            if (!(response instanceof ModbusPDUReadInputRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadInputRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadInputRegistersRequest req = (ModbusPDUReadInputRegistersRequest)request;
            ModbusPDUReadInputRegistersResponse resp = (ModbusPDUReadInputRegistersResponse)response;
            ReadBufferByteBased io = new ReadBufferByteBased(resp.getValue());
            if (tagDataTypeSize < 2) {
                io.readByte(new WithReaderArgs[0]);
            }
            return DataItem.staticParse((ReadBuffer)io, dataType, Math.max(Math.round((float)req.getQuantity() / ((float)tagDataTypeSize / 2.0f)), 1));
        }
        if (request instanceof ModbusPDUReadHoldingRegistersRequest) {
            if (!(response instanceof ModbusPDUReadHoldingRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadHoldingRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadHoldingRegistersRequest req = (ModbusPDUReadHoldingRegistersRequest)request;
            ModbusPDUReadHoldingRegistersResponse resp = (ModbusPDUReadHoldingRegistersResponse)response;
            ReadBufferByteBased io = new ReadBufferByteBased(resp.getValue());
            if (dataType != ModbusDataType.STRING && tagDataTypeSize < 2) {
                io.readByte(new WithReaderArgs[0]);
            }
            return DataItem.staticParse((ReadBuffer)io, dataType, Math.max(Math.round((float)req.getQuantity() / ((float)tagDataTypeSize / 2.0f)), 1));
        }
        if (request instanceof ModbusPDUReadFileRecordRequest) {
            short dataLength;
            ReadBufferByteBased io;
            if (!(response instanceof ModbusPDUReadFileRecordResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadFileRecordResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadFileRecordRequest req = (ModbusPDUReadFileRecordRequest)request;
            ModbusPDUReadFileRecordResponse resp = (ModbusPDUReadFileRecordResponse)response;
            if (resp.getItems().size() == 2 && resp.getItems().size() == req.getItems().size()) {
                io = new ReadBufferByteBased(ArrayUtils.addAll((byte[])resp.getItems().get(0).getData(), (byte[])resp.getItems().get(1).getData()));
                dataLength = (short)(resp.getItems().get(0).getLengthInBytes() + resp.getItems().get(1).getLengthInBytes() - 4);
            } else if (resp.getItems().size() == 1 && resp.getItems().size() == req.getItems().size()) {
                io = new ReadBufferByteBased(resp.getItems().get(0).getData());
                dataLength = (short)(resp.getItems().get(0).getLengthInBytes() - 2);
            } else {
                throw new PlcRuntimeException("Unexpected number of groups in response. Expected " + req.getItems().size() + ", but got " + resp.getItems().size());
            }
            if (tagDataTypeSize < 2) {
                io.readByte(new WithReaderArgs[0]);
            }
            return DataItem.staticParse((ReadBuffer)io, dataType, Math.round(Math.max((float)dataLength / 2.0f, 1.0f) / Math.max((float)tagDataTypeSize / 2.0f, 1.0f)));
        }
        return null;
    }

    protected byte[] fromPlcValue(PlcTag tag, PlcValue plcValue) {
        ModbusDataType tagDataType = ((ModbusTag)tag).getDataType();
        try {
            if (tag instanceof ModbusTagCoil) {
                if (plcValue instanceof PlcBOOL) {
                    byte byteValue = (byte)(plcValue.getBoolean() ? 1 : 0);
                    return new byte[]{byteValue};
                }
                if (plcValue instanceof PlcList) {
                    int i;
                    PlcList valueList = (PlcList)plcValue;
                    WriteBufferByteBased wb = new WriteBufferByteBased((plcValue.getLength() - 1) / 8 + 1);
                    int paddingBits = 8 - plcValue.getLength() % 8;
                    if (paddingBits < 8) {
                        i = 0;
                        while (i < paddingBits) {
                            wb.writeBit(false, new WithWriterArgs[0]);
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < plcValue.getLength()) {
                        PlcValue value = valueList.getIndex(plcValue.getLength() - 1 - i);
                        if (!(value instanceof PlcBOOL)) {
                            throw new PlcRuntimeException("Expecting only BOOL values when writing coils.");
                        }
                        PlcBOOL boolValue = (PlcBOOL)value;
                        wb.writeBit(boolValue.getBoolean(), new WithWriterArgs[0]);
                        ++i;
                    }
                    byte[] bytes = wb.getBytes();
                    ArrayUtils.reverse((byte[])bytes);
                    return bytes;
                }
                throw new PlcRuntimeException("Expecting only BOOL or List values when writing coils.");
            }
            if (plcValue instanceof PlcList) {
                WriteBufferByteBased writeBuffer = new WriteBufferByteBased(DataItem.getLengthInBytes(plcValue, tagDataType, plcValue.getLength()));
                DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue, tagDataType, plcValue.getLength(), ByteOrder.BIG_ENDIAN);
                byte[] data = writeBuffer.getBytes();
                if (((ModbusTag)tag).getDataType() == ModbusDataType.BOOL) {
                    byte[] bytes = new byte[data.length];
                    int i = 0;
                    while (i < data.length) {
                        bytes[i] = this.reverseBitsOfByte(data[i]);
                        ++i;
                    }
                    return bytes;
                }
                return data;
            }
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased(DataItem.getLengthInBytes(plcValue, tagDataType, plcValue.getLength()));
            DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue, tagDataType, plcValue.getLength(), ByteOrder.BIG_ENDIAN);
            return writeBuffer.getBytes();
        }
        catch (SerializationException e) {
            throw new PlcRuntimeException("Unable to parse PlcValue :- " + (Object)((Object)e));
        }
    }

    protected byte reverseBitsOfByte(byte b) {
        BitSet bits = BitSet.valueOf(new byte[]{b});
        BitSet reverse = BitSet.valueOf(new byte[]{-1});
        int j = 0;
        while (j < 8) {
            reverse.set(j, bits.get(7 - j));
            ++j;
        }
        return Arrays.copyOf(reverse.toByteArray(), 1)[0];
    }

    protected PlcValue readCoilBooleanList(int count, byte[] data) throws ParseException {
        ReadBufferByteBased io = new ReadBufferByteBased(data);
        if (count == 1) {
            io.readInt(7, new WithReaderArgs[0]);
            return new PlcBOOL(io.readBit(new WithReaderArgs[0]));
        }
        int numFullBytes = count / 8;
        int numBitsIncompleteByte = count - numFullBytes * 8;
        PlcValue[] values = new PlcValue[count];
        int i = 0;
        while (i < numFullBytes) {
            values[i * 8 + 7] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            values[i * 8 + 6] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            values[i * 8 + 5] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            values[i * 8 + 4] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            values[i * 8 + 3] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            values[i * 8 + 2] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            values[i * 8 + 1] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            values[i * 8] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
            ++i;
        }
        if (numBitsIncompleteByte > 0) {
            io.readInt(8 - numBitsIncompleteByte, new WithReaderArgs[0]);
            i = 1;
            while (i <= numBitsIncompleteByte) {
                values[numFullBytes * 8 + (numBitsIncompleteByte - i)] = new PlcBOOL(io.readBit(new WithReaderArgs[0]));
                ++i;
            }
        }
        return new PlcList(Arrays.asList(values));
    }
}

