/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.optimizer;

import io.vavr.control.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;

public abstract class BaseOptimizer {
    protected List<PlcReadRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        return Collections.singletonList(readRequest);
    }

    protected PlcReadResponse processReadResponses(PlcReadRequest readRequest, Map<PlcReadRequest, Either<PlcReadResponse, Exception>> readResponses) {
        HashMap<String, ResponseItem<PlcValue>> tags = new HashMap<String, ResponseItem<PlcValue>>();
        for (Map.Entry<PlcReadRequest, Either<PlcReadResponse, Exception>> requestsEntries : readResponses.entrySet()) {
            PlcReadRequest curRequest = requestsEntries.getKey();
            Either<PlcReadResponse, Exception> readResponse = requestsEntries.getValue();
            for (String tagName : curRequest.getTagNames()) {
                if (readResponse.isLeft()) {
                    PlcReadResponse subReadResponse = (PlcReadResponse)readResponse.getLeft();
                    PlcResponseCode responseCode = subReadResponse.getResponseCode(tagName);
                    PlcValue value = subReadResponse.getAsPlcValue().getValue(tagName);
                    tags.put(tagName, new ResponseItem<PlcValue>(responseCode, value));
                    continue;
                }
                tags.put(tagName, new ResponseItem<Object>(PlcResponseCode.INTERNAL_ERROR, null));
            }
        }
        return new DefaultPlcReadResponse(readRequest, tags);
    }

    protected List<PlcWriteRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        return Collections.singletonList(writeRequest);
    }

    protected PlcWriteResponse processWriteResponses(PlcWriteRequest writeRequest, Map<PlcWriteRequest, Either<PlcWriteResponse, Exception>> writeResponses) {
        HashMap<String, PlcResponseCode> tags = new HashMap<String, PlcResponseCode>();
        for (Map.Entry<PlcWriteRequest, Either<PlcWriteResponse, Exception>> requestsEntries : writeResponses.entrySet()) {
            PlcWriteRequest subWriteRequest = requestsEntries.getKey();
            Either<PlcWriteResponse, Exception> writeResponse = requestsEntries.getValue();
            for (String tagName : subWriteRequest.getTagNames()) {
                if (writeResponse.isLeft()) {
                    PlcWriteResponse subWriteResponse = (PlcWriteResponse)writeResponse.getLeft();
                    tags.put(tagName, subWriteResponse.getResponseCode(tagName));
                    continue;
                }
                tags.put(tagName, PlcResponseCode.INTERNAL_ERROR);
            }
        }
        return new DefaultPlcWriteResponse(writeRequest, tags);
    }

    protected List<PlcSubscriptionRequest> processSubscriptionRequest(PlcSubscriptionRequest subscriptionRequest, DriverContext driverContext) {
        return Collections.singletonList(subscriptionRequest);
    }

    protected PlcSubscriptionResponse processSubscriptionResponses(PlcSubscriptionRequest subscriptionRequest, Map<PlcSubscriptionRequest, Either<PlcSubscriptionResponse, Exception>> subscriptionResponses) {
        return null;
    }

    protected List<PlcUnsubscriptionRequest> processUnsubscriptionRequest(PlcUnsubscriptionRequest unsubscriptionRequest, DriverContext driverContext) {
        return Collections.singletonList(unsubscriptionRequest);
    }

    protected PlcUnsubscriptionResponse processUnsubscriptionResponses(PlcUnsubscriptionRequest unsubscriptionRequest, Map<PlcUnsubscriptionRequest, Either<PlcUnsubscriptionResponse, Exception>> unsubscriptionResponses) {
        return null;
    }

    public CompletableFuture<PlcReadResponse> optimizedRead(PlcReadRequest readRequest, Plc4xProtocolBase<?> reader) {
        List<PlcReadRequest> subRequests = this.processReadRequest(readRequest, reader.getDriverContext());
        return this.send(readRequest, subRequests, reader::read, response -> this.processReadResponses(readRequest, (Map<PlcReadRequest, Either<PlcReadResponse, Exception>>)response));
    }

    public CompletableFuture<PlcWriteResponse> optimizedWrite(PlcWriteRequest writeRequest, Plc4xProtocolBase<?> writer) {
        List<PlcWriteRequest> subRequests = this.processWriteRequest(writeRequest, writer.getDriverContext());
        return this.send(writeRequest, subRequests, writer::write, response -> this.processWriteResponses(writeRequest, (Map<PlcWriteRequest, Either<PlcWriteResponse, Exception>>)response));
    }

    public CompletableFuture<PlcSubscriptionResponse> optimizedSubscribe(PlcSubscriptionRequest subscriptionRequest, Plc4xProtocolBase<?> subscriber) {
        List<PlcSubscriptionRequest> subRequests = this.processSubscriptionRequest(subscriptionRequest, subscriber.getDriverContext());
        return this.send(subscriptionRequest, subRequests, subscriber::subscribe, response -> this.processSubscriptionResponses(subscriptionRequest, (Map<PlcSubscriptionRequest, Either<PlcSubscriptionResponse, Exception>>)response));
    }

    public CompletableFuture<PlcUnsubscriptionResponse> optimizedUnsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest, Plc4xProtocolBase<?> subscriber) {
        List<PlcUnsubscriptionRequest> subRequests = this.processUnsubscriptionRequest(unsubscriptionRequest, subscriber.getDriverContext());
        return this.send(unsubscriptionRequest, subRequests, subscriber::unsubscribe, response -> this.processUnsubscriptionResponses(unsubscriptionRequest, (Map<PlcUnsubscriptionRequest, Either<PlcUnsubscriptionResponse, Exception>>)response));
    }

    private <REQ extends PlcRequest, RES extends PlcResponse> CompletableFuture<RES> send(REQ originalRequest, List<REQ> requests, Function<REQ, CompletableFuture<RES>> sender, Function<Map<REQ, Either<RES, Exception>>, RES> responseProcessor) {
        if (requests.size() == 1 && requests.get(0) == originalRequest) {
            return sender.apply((PlcRequest)requests.get(0));
        }
        if (requests.isEmpty()) {
            return CompletableFuture.completedFuture((PlcResponse)responseProcessor.apply(Collections.emptyMap()));
        }
        CompletableFuture parentFuture = new CompletableFuture();
        HashMap subFutures = new HashMap();
        for (PlcRequest subRequest : requests) {
            subFutures.put(subRequest, sender.apply(subRequest));
        }
        ((CompletableFuture)CompletableFuture.allOf(subFutures.values().toArray(new CompletableFuture[0])).handle((aVoid, t) -> {
            if (t != null) {
                parentFuture.completeExceptionally((Throwable)t);
            }
            HashMap<PlcRequest, Either> results = new HashMap<PlcRequest, Either>();
            for (Map.Entry subFutureEntry : subFutures.entrySet()) {
                PlcRequest subRequest = (PlcRequest)subFutureEntry.getKey();
                CompletableFuture subFuture = (CompletableFuture)subFutureEntry.getValue();
                try {
                    PlcResponse subResponse = (PlcResponse)subFuture.get();
                    results.put(subRequest, Either.left((Object)subResponse));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    results.put(subRequest, Either.right((Object)new Exception("Something went wrong")));
                }
                catch (Exception e) {
                    results.put(subRequest, Either.right((Object)new Exception("Something went wrong")));
                }
            }
            PlcResponse response = (PlcResponse)responseProcessor.apply(results);
            parentFuture.complete(response);
            return Void.TYPE;
        })).exceptionally(throwable -> {
            parentFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        return parentFuture;
    }
}

