/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hertzbeat.alert.expr.AlertExpressionBaseVisitor;
import org.apache.hertzbeat.alert.expr.AlertExpressionParser;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;

public class AlertExpressionEvalVisitor
extends AlertExpressionBaseVisitor<List<Map<String, Object>>> {
    private static final String THRESHOLD = "__threshold__";
    private static final String NAME = "__name__";
    private static final String VALUE = "__value__";
    private static final String TIMESTAMP = "__timestamp__";
    private final QueryExecutor executor;
    private final CommonTokenStream tokens;

    public AlertExpressionEvalVisitor(QueryExecutor executor, CommonTokenStream tokens) {
        this.executor = executor;
        this.tokens = tokens;
    }

    @Override
    public List<Map<String, Object>> visitExpression(AlertExpressionParser.ExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public List<Map<String, Object>> visitParenExpr(AlertExpressionParser.ParenExprContext ctx) {
        return (List)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public List<Map<String, Object>> visitComparisonExpr(AlertExpressionParser.ComparisonExprContext ctx) {
        List leftResult = (List)this.visit((ParseTree)ctx.left);
        List rightResult = (List)this.visit((ParseTree)ctx.right);
        if (rightResult.size() == 1 && ((Map)rightResult.get(0)).containsKey(THRESHOLD)) {
            double threshold = (Double)((Map)rightResult.get(0)).get(THRESHOLD);
            String operator = ctx.op.getText();
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (Map item : leftResult) {
                Object queryValues = item.get(VALUE);
                if (queryValues == null) continue;
                Object matchValue = this.evaluateCondition(queryValues, operator, threshold);
                HashMap<String, Object> resultMap = new HashMap<String, Object>(item);
                resultMap.put(VALUE, matchValue);
                result.add(resultMap);
            }
            return result;
        }
        return new LinkedList<Map<String, Object>>();
    }

    @Override
    public List<Map<String, Object>> visitAndExpr(AlertExpressionParser.AndExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Set rightLabelsSet = rightOperand.stream().filter(item -> item.get(VALUE) != null).map(this::labelKey).collect(Collectors.toSet());
        for (Map leftItem : leftOperand) {
            String labelKey;
            Object leftVal = leftItem.get(VALUE);
            if (leftVal == null || !rightLabelsSet.contains(labelKey = this.labelKey(leftItem))) continue;
            results.add(new HashMap(leftItem));
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> visitOrExpr(AlertExpressionParser.OrExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        Map<String, Map> leftLabelMap = leftOperand.stream().filter(item -> item.get(VALUE) != null).collect(Collectors.toMap(this::labelKey, HashMap::new, (k1, k2) -> k1));
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(leftLabelMap.values());
        for (Map rightItem : rightOperand) {
            String key;
            Object rightVal = rightItem.get(VALUE);
            if (rightVal == null || leftLabelMap.containsKey(key = this.labelKey(rightItem))) continue;
            results.add(new HashMap(rightItem));
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> visitUnlessExpr(AlertExpressionParser.UnlessExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Set rightLabelSet = rightOperand.stream().filter(item -> item.get(VALUE) != null).map(this::labelKey).collect(Collectors.toSet());
        for (Map leftItem : leftOperand) {
            Object leftVal = leftItem.get(VALUE);
            if (leftVal == null || rightLabelSet.contains(this.labelKey(leftItem))) continue;
            results.add(new HashMap(leftItem));
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> visitLiteralExpr(AlertExpressionParser.LiteralExprContext ctx) {
        double value = Double.parseDouble(ctx.number().getText());
        ArrayList<Map<String, Object>> numAsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Double> valueMap = new HashMap<String, Double>();
        valueMap.put(THRESHOLD, value);
        numAsList.add(valueMap);
        return numAsList;
    }

    @Override
    public List<Map<String, Object>> visitPromqlExpr(AlertExpressionParser.PromqlExprContext ctx) {
        String rawPromql = this.tokens.getText((RuleContext)ctx.promql());
        return this.executor.execute(rawPromql);
    }

    @Override
    public List<Map<String, Object>> visitSqlExpr(AlertExpressionParser.SqlExprContext ctx) {
        String rawSql = this.tokens.getText((RuleContext)ctx.selectSql());
        return this.executor.execute(rawSql);
    }

    @Override
    public List<Map<String, Object>> visitSqlCallExpr(AlertExpressionParser.SqlCallExprContext ctx) {
        return this.callSqlOrPromql(this.tokens.getText((RuleContext)ctx.string()));
    }

    @Override
    public List<Map<String, Object>> visitPromqlCallExpr(AlertExpressionParser.PromqlCallExprContext ctx) {
        return this.callSqlOrPromql(this.tokens.getText((RuleContext)ctx.string()));
    }

    private Object evaluateCondition(Object value, String operator, Double threshold) {
        switch (operator) {
            case ">": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).max(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue > threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) > threshold ? value : null;
            }
            case ">=": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).max(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue >= threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) >= threshold ? value : null;
            }
            case "<": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).min(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue < threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) < threshold ? value : null;
            }
            case "<=": {
                if (value instanceof List) {
                    List values = (List)value;
                    Double doubleValue = values.stream().map(v -> Double.valueOf(v.toString())).min(Double::compareTo).orElse(null);
                    if (doubleValue != null) {
                        return doubleValue <= threshold ? doubleValue : null;
                    }
                    return null;
                }
                return Double.parseDouble(value.toString()) <= threshold ? value : null;
            }
            case "==": {
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v2 : values) {
                        if (!v2.equals(threshold)) continue;
                        return v2;
                    }
                    return null;
                }
                return value.equals(threshold) ? value : null;
            }
            case "!=": {
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v3 : values) {
                        if (!v3.equals(threshold)) continue;
                        return null;
                    }
                    return value;
                }
                return value.equals(threshold) ? null : value;
            }
        }
        return null;
    }

    private List<Map<String, Object>> callSqlOrPromql(String text) {
        String script = text.substring(1, text.length() - 1);
        return this.executor.execute(script);
    }

    private String labelKey(Map<String, Object> labelsMap) {
        if (null == labelsMap || labelsMap.isEmpty()) {
            return "-";
        }
        String key = labelsMap.entrySet().stream().filter(e -> !((String)e.getKey()).equals(VALUE) && !((String)e.getKey()).equals(NAME) && !((String)e.getKey()).equals(TIMESTAMP)).sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + (e.getValue() == null ? "" : e.getValue())).collect(Collectors.joining(","));
        return key.isEmpty() ? "-" : key;
    }
}

