/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.processor;

import com.usthe.sureness.processor.Processor;
import com.usthe.sureness.processor.exception.SurenessAuthenticationException;
import com.usthe.sureness.processor.exception.SurenessAuthorizationException;
import com.usthe.sureness.processor.exception.UnauthorizedException;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectSum;
import java.util.List;

public abstract class BaseProcessor
implements Processor {
    @Override
    public abstract boolean canSupportSubjectClass(Class<?> var1);

    @Override
    public abstract Class<?> getSupportSubjectClass();

    @Override
    public SubjectSum process(Subject var) throws SurenessAuthenticationException, SurenessAuthorizationException {
        Subject subject = this.authenticated(var);
        this.authorized(subject);
        return subject.generateSubjectSummary();
    }

    public abstract Subject authenticated(Subject var1) throws SurenessAuthenticationException;

    public void authorized(Subject var) throws SurenessAuthorizationException {
        List ownRoles = (List)var.getOwnRoles();
        List supportRoles = (List)var.getSupportRoles();
        if (supportRoles == null) {
            return;
        }
        if (ownRoles != null) {
            if (supportRoles.stream().anyMatch(ownRoles::contains)) {
                return;
            }
        }
        throw new UnauthorizedException("do not have the role to access resource");
    }
}

