/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.hertzbeat.manager.config.AiProperties;
import org.apache.hertzbeat.manager.pojo.dto.AiControllerRequestParam;
import org.apache.hertzbeat.manager.service.ai.AiService;
import org.apache.hertzbeat.manager.service.ai.factory.AiServiceFactoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@Tag(name="AI Manage API")
@RestController
@RequestMapping(value={"/api/ai"})
public class AiController {
    @Autowired(required=false)
    private AiServiceFactoryImpl aiServiceFactory;
    @Autowired
    private AiProperties aiProperties;

    @PostMapping(path={"/get"}, produces={"text/event-stream"})
    @Operation(summary="Artificial intelligence questions and Answers", description="Artificial intelligence questions and Answers")
    public Flux<ServerSentEvent<String>> requestAi(@Parameter(description="Request text", example="Who are you") @RequestBody AiControllerRequestParam requestParam) {
        Assert.notNull((Object)this.aiServiceFactory, "please check that your type value is consistent with the documentation on the website");
        AiService aiServiceImplBean = this.aiServiceFactory.getAiServiceImplBean(this.aiProperties.getType());
        return aiServiceImplBean.requestAi(requestParam.getText());
    }
}

