/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum ModbusDeviceInformationLevel {
    BASIC(1),
    REGULAR(2),
    EXTENDED(3),
    INDIVIDUAL(4);

    private static final Map<Short, ModbusDeviceInformationLevel> map;
    private final short value;

    static {
        map = new HashMap<Short, ModbusDeviceInformationLevel>();
        ModbusDeviceInformationLevel[] modbusDeviceInformationLevelArray = ModbusDeviceInformationLevel.values();
        int n = modbusDeviceInformationLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModbusDeviceInformationLevel value = modbusDeviceInformationLevelArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private ModbusDeviceInformationLevel(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static ModbusDeviceInformationLevel enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

