/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.db;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.hertzbeat.common.entity.dto.query.DatasourceQuery;
import org.apache.hertzbeat.common.entity.dto.query.DatasourceQueryData;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.TimePeriodUtil;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;
import org.apache.hertzbeat.warehouse.store.history.vm.PromQlQueryContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class PromqlQueryExecutor
implements QueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(PromqlQueryExecutor.class);
    private static final String supportQueryLanguage = "promql";
    private static final String QUERY_RANGE_PATH = "/api/v1/query_range";
    private static final String QUERY_PATH = "/api/v1/query";
    protected static final String HTTP_QUERY_PARAM = "query";
    protected static final String HTTP_TIME_PARAM = "time";
    protected static final String HTTP_START_PARAM = "start";
    protected static final String HTTP_END_PARAM = "end";
    protected static final String HTTP_STEP_PARAM = "step";
    private static final String INNER_KEY_TIME = "__ts__";
    private static final String INNER_KEY_VALUE = "__value__";
    private final RestTemplate restTemplate;
    private final HttpPromqlProperties httpPromqlProperties;

    PromqlQueryExecutor(RestTemplate restTemplate, HttpPromqlProperties httpPromqlProperties) {
        this.restTemplate = restTemplate;
        this.httpPromqlProperties = httpPromqlProperties;
    }

    @Override
    public List<Map<String, Object>> execute(String queryString) {
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.httpPromqlProperties.username()) && StringUtils.hasText((String)this.httpPromqlProperties.password())) {
                String authStr = this.httpPromqlProperties.username() + ":" + this.httpPromqlProperties.password();
                String encodedAuth = Base64Util.encode((String)authStr);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.httpPromqlProperties.url + QUERY_PATH));
            uriComponentsBuilder.queryParam(HTTP_QUERY_PARAM, new Object[]{queryString});
            URI uri = uriComponentsBuilder.build().toUri();
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, PromQlQueryContent.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                    List<PromQlQueryContent.ContentData.Content> contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                    for (PromQlQueryContent.ContentData.Content content : contents) {
                        Map<String, String> labels = content.getMetric();
                        HashMap<String, Object> queryResult = new HashMap<String, Object>(8);
                        queryResult.putAll(labels);
                        if (content.getValue() != null && content.getValue().length == 2) {
                            queryResult.put("__timestamp__", content.getValue()[0]);
                            queryResult.put(INNER_KEY_VALUE, content.getValue()[1]);
                        } else if (content.getValues() != null && !content.getValues().isEmpty()) {
                            LinkedList<Object> values = new LinkedList<Object>();
                            for (Object[] valueArr : content.getValues()) {
                                values.add(valueArr[1]);
                            }
                            queryResult.put(INNER_KEY_VALUE, values);
                        }
                        results.add(queryResult);
                    }
                }
            } else {
                log.error("query metrics data from greptime failed. {}", (Object)responseEntity);
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        return results;
    }

    @Override
    public DatasourceQueryData query(DatasourceQuery datasourceQuery) {
        DatasourceQueryData.DatasourceQueryDataBuilder queryDataBuilder = DatasourceQueryData.builder().refId(datasourceQuery.getRefId()).status(Integer.valueOf(200));
        try {
            URI uri;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.httpPromqlProperties.username()) && StringUtils.hasText((String)this.httpPromqlProperties.password())) {
                String authStr = this.httpPromqlProperties.username() + ":" + this.httpPromqlProperties.password();
                String encodedAuth = new String(Base64.encodeBase64((byte[])authStr.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            if (datasourceQuery.getTimeType().equals("range")) {
                uri = UriComponentsBuilder.fromHttpUrl((String)(this.httpPromqlProperties.url() + QUERY_RANGE_PATH)).queryParam(HTTP_QUERY_PARAM, new Object[]{datasourceQuery.getExpr()}).queryParam(HTTP_START_PARAM, new Object[]{datasourceQuery.getStart()}).queryParam(HTTP_END_PARAM, new Object[]{datasourceQuery.getEnd()}).queryParam(HTTP_STEP_PARAM, new Object[]{datasourceQuery.getStep()}).build().toUri();
            } else if (datasourceQuery.getTimeType().equals("instant")) {
                uri = UriComponentsBuilder.fromHttpUrl((String)(this.httpPromqlProperties.url() + QUERY_PATH)).queryParam(HTTP_QUERY_PARAM, new Object[]{datasourceQuery.getExpr()}).build().toUri();
            } else {
                throw new IllegalArgumentException(String.format("no such time type for query id {}.", datasourceQuery.getRefId()));
            }
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, PromQlQueryContent.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("query metrics data from promql http api success. {}", (Object)uri);
                if (responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                    List<PromQlQueryContent.ContentData.Content> contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                    LinkedList<DatasourceQueryData.SchemaData> schemaDataList = new LinkedList<DatasourceQueryData.SchemaData>();
                    for (PromQlQueryContent.ContentData.Content content : contents) {
                        DatasourceQueryData.MetricSchema.MetricSchemaBuilder schemaBuilder = DatasourceQueryData.MetricSchema.builder().fields(List.of(DatasourceQueryData.MetricField.builder().name(INNER_KEY_TIME).type(HTTP_TIME_PARAM).build(), DatasourceQueryData.MetricField.builder().name(INNER_KEY_VALUE).type("number").build())).labels(content.getMetric());
                        List<Object[]> values = datasourceQuery.getTimeType().equals("range") ? content.getValues() : List.of(content.getValue());
                        values.forEach(objects -> {
                            objects[0] = TimePeriodUtil.normalizeToMilliseconds((Object)objects[0]);
                        });
                        DatasourceQueryData.SchemaData.SchemaDataBuilder schemaData = DatasourceQueryData.SchemaData.builder().schema(schemaBuilder.build()).data(values);
                        schemaDataList.add(schemaData.build());
                    }
                    queryDataBuilder.frames(schemaDataList);
                }
            } else {
                log.error("query metrics data from victoria-metrics failed. {}", (Object)responseEntity);
                queryDataBuilder.msg("query metrics data from victoria-metrics failed. ");
                queryDataBuilder.status(Integer.valueOf(responseEntity.getStatusCode().value()));
            }
        }
        catch (Exception e) {
            log.error("query metrics data from victoria-metrics error. {}.", (Object)e.getMessage(), (Object)e);
            queryDataBuilder.msg("query metrics data from victoria-metrics error: " + e.getMessage());
            queryDataBuilder.status(Integer.valueOf(400));
        }
        return queryDataBuilder.build();
    }

    @Override
    public boolean support(String queryLanguage) {
        return StringUtils.hasText((String)queryLanguage) && queryLanguage.equalsIgnoreCase(supportQueryLanguage);
    }

    protected record HttpPromqlProperties(String url, String username, String password) {
    }
}

