/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.common;

import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public class IpmiCode {
    public static <T extends Enum<T>> T fromByte(Class<T> type, byte code) {
        for (Enum value : (Enum[])type.getEnumConstants()) {
            if (((Code)((Object)value)).getCode() != code) continue;
            return (T)value;
        }
        throw new IllegalArgumentException("Unknown " + type.getSimpleName() + " code 0x" + UnsignedBytes.toString((byte)code, (int)16));
    }

    public static <T extends Enum<T>> T fromInt(Class<T> type, int code) {
        return IpmiCode.fromByte(type, ByteConvertUtils.checkCastByte(code));
    }

    public static <T extends Enum<T>> T fromBuffer(Class<T> type, ByteBuffer buffer) {
        return IpmiCode.fromByte(type, buffer.get());
    }

    public static <T extends Enum<T>> T fromBufferWithMask(Class<T> type, ByteBuffer buffer, int mask) {
        return IpmiCode.fromByte(type, (byte)(buffer.get() & mask));
    }

    public static interface Code {
        public byte getCode();

        default public String getDescription() {
            return "No description";
        }
    }
}

