/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.Into;
import io.greptime.v1.Common;

public enum DataType {
    Bool,
    Int8,
    Int16,
    Int32,
    Int64,
    UInt8,
    UInt16,
    UInt32,
    UInt64,
    Float32,
    Float64,
    Binary,
    String,
    Date,
    DateTime,
    TimestampSecond,
    TimestampMillisecond,
    TimestampMicrosecond,
    TimestampNanosecond,
    TimeSecond,
    TimeMilliSecond,
    TimeMicroSecond,
    TimeNanoSecond,
    IntervalYearMonth,
    IntervalDayTime,
    IntervalMonthDayNano,
    Decimal128,
    Json;


    public boolean isTimestamp() {
        return this == TimestampSecond || this == TimestampMillisecond || this == TimestampMicrosecond || this == TimestampNanosecond;
    }

    public Common.ColumnDataType toProtoValue() {
        switch (this) {
            case Bool: {
                return Common.ColumnDataType.BOOLEAN;
            }
            case Int8: {
                return Common.ColumnDataType.INT8;
            }
            case Int16: {
                return Common.ColumnDataType.INT16;
            }
            case Int32: {
                return Common.ColumnDataType.INT32;
            }
            case Int64: {
                return Common.ColumnDataType.INT64;
            }
            case UInt8: {
                return Common.ColumnDataType.UINT8;
            }
            case UInt16: {
                return Common.ColumnDataType.UINT16;
            }
            case UInt32: {
                return Common.ColumnDataType.UINT32;
            }
            case UInt64: {
                return Common.ColumnDataType.UINT64;
            }
            case Float32: {
                return Common.ColumnDataType.FLOAT32;
            }
            case Float64: {
                return Common.ColumnDataType.FLOAT64;
            }
            case Binary: {
                return Common.ColumnDataType.BINARY;
            }
            case String: {
                return Common.ColumnDataType.STRING;
            }
            case Date: {
                return Common.ColumnDataType.DATE;
            }
            case DateTime: {
                return Common.ColumnDataType.DATETIME;
            }
            case TimestampSecond: {
                return Common.ColumnDataType.TIMESTAMP_SECOND;
            }
            case TimestampMillisecond: {
                return Common.ColumnDataType.TIMESTAMP_MILLISECOND;
            }
            case TimestampMicrosecond: {
                return Common.ColumnDataType.TIMESTAMP_MICROSECOND;
            }
            case TimestampNanosecond: {
                return Common.ColumnDataType.TIMESTAMP_NANOSECOND;
            }
            case TimeSecond: {
                return Common.ColumnDataType.TIME_SECOND;
            }
            case TimeMilliSecond: {
                return Common.ColumnDataType.TIME_MILLISECOND;
            }
            case TimeMicroSecond: {
                return Common.ColumnDataType.TIME_MICROSECOND;
            }
            case TimeNanoSecond: {
                return Common.ColumnDataType.TIME_NANOSECOND;
            }
            case IntervalYearMonth: {
                return Common.ColumnDataType.INTERVAL_YEAR_MONTH;
            }
            case IntervalDayTime: {
                return Common.ColumnDataType.INTERVAL_DAY_TIME;
            }
            case IntervalMonthDayNano: {
                return Common.ColumnDataType.INTERVAL_MONTH_DAY_NANO;
            }
            case Decimal128: {
                return Common.ColumnDataType.DECIMAL128;
            }
            case Json: {
                return Common.ColumnDataType.JSON;
            }
        }
        return null;
    }

    public static class DecimalTypeExtension
    implements Into<Common.DecimalTypeExtension> {
        static final int MAX_DECIMAL128_PRECISION = 38;
        static final int DEFAULT_DECIMAL128_SCALE = 10;
        public static final DecimalTypeExtension DEFAULT = new DecimalTypeExtension(38, 10);
        private final int precision;
        private final int scale;

        public DecimalTypeExtension(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        public Common.DecimalTypeExtension into() {
            return Common.DecimalTypeExtension.newBuilder().setPrecision(this.precision).setScale(this.scale).build();
        }
    }
}

