/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;

final class KafkaConsumerAttributesExtractor
implements AttributesExtractor<KafkaProcessRequest, Void> {
    private static final AttributeKey<String> MESSAGING_DESTINATION_PARTITION_ID = AttributeKey.stringKey((String)"messaging.destination.partition.id");
    private static final AttributeKey<String> MESSAGING_KAFKA_CONSUMER_GROUP = AttributeKey.stringKey((String)"messaging.kafka.consumer.group");
    private static final AttributeKey<String> MESSAGING_KAFKA_MESSAGE_KEY = AttributeKey.stringKey((String)"messaging.kafka.message.key");
    private static final AttributeKey<Long> MESSAGING_KAFKA_MESSAGE_OFFSET = AttributeKey.longKey((String)"messaging.kafka.message.offset");
    private static final AttributeKey<Boolean> MESSAGING_KAFKA_MESSAGE_TOMBSTONE = AttributeKey.booleanKey((String)"messaging.kafka.message.tombstone");

    KafkaConsumerAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaProcessRequest request) {
        String consumerGroup;
        ConsumerRecord<?, ?> record = request.getRecord();
        attributes.put(MESSAGING_DESTINATION_PARTITION_ID, (Object)String.valueOf(record.partition()));
        attributes.put(MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)record.offset());
        Object key = record.key();
        if (key != null && KafkaConsumerAttributesExtractor.canSerialize(key.getClass())) {
            attributes.put(MESSAGING_KAFKA_MESSAGE_KEY, (Object)key.toString());
        }
        if (record.value() == null) {
            attributes.put(MESSAGING_KAFKA_MESSAGE_TOMBSTONE, (Object)true);
        }
        if ((consumerGroup = request.getConsumerGroup()) != null) {
            attributes.put(MESSAGING_KAFKA_CONSUMER_GROUP, (Object)consumerGroup);
        }
    }

    private static boolean canSerialize(Class<?> keyClass) {
        return !keyClass.isArray() && keyClass != ByteBuffer.class;
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaProcessRequest request, @Nullable Void unused, @Nullable Throwable error) {
    }
}

