/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.UserMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.ibatis.annotations.Param;

public class UserMetaPostgreSQLProvider
extends UserMetaBaseSQLProvider {
    @Override
    public String softDeleteUserMetaByUserId(Long userId) {
        return "UPDATE user_meta SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE user_id = #{userId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteUserMetasByMetalakeId(Long metalakeId) {
        return "UPDATE user_meta SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))  WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String insertUserMetaOnDuplicateKeyUpdate(UserPO userPO) {
        return "INSERT INTO user_meta(user_id, user_name,metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{userMeta.userId}, #{userMeta.userName}, #{userMeta.metalakeId}, #{userMeta.auditInfo}, #{userMeta.currentVersion}, #{userMeta.lastVersion}, #{userMeta.deletedAt} ) ON CONFLICT(user_id) DO UPDATE SET user_name = #{userMeta.userName}, metalake_id = #{userMeta.metalakeId}, audit_info = #{userMeta.auditInfo}, current_version = #{userMeta.currentVersion}, last_version = #{userMeta.lastVersion}, deleted_at = #{userMeta.deletedAt}";
    }

    @Override
    public String listExtendedUserPOsByMetalakeId(Long metalakeId) {
        return "SELECT ut.user_id as userId, ut.user_name as userName, ut.metalake_id as metalakeId, ut.audit_info as auditInfo, ut.current_version as currentVersion, ut.last_version as lastVersion, ut.deleted_at as deletedAt, JSON_AGG(rot.role_name) as roleNames, JSON_AGG(rot.role_id) as roleIds FROM user_meta ut LEFT OUTER JOIN ( SELECT * FROM user_role_rel WHERE deleted_at = 0) AS rt ON rt.user_id = ut.user_id LEFT OUTER JOIN ( SELECT * FROM role_meta WHERE deleted_at = 0) AS rot ON rot.role_id = rt.role_id WHERE  ut.deleted_at = 0 AND ut.metalake_id = #{metalakeId} GROUP BY ut.user_id";
    }

    @Override
    public String deleteUserMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM user_meta WHERE user_id IN (SELECT user_id FROM user_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

