/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.List;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchUserException;

public class UserDetails
extends Command {
    protected final String metalake;
    protected final String user;

    public UserDetails(CommandContext context, String metalake, String user) {
        super(context);
        this.metalake = metalake;
        this.user = user;
    }

    @Override
    public void handle() {
        List<String> roles = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            roles = client.getUser(this.user).roles();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchUserException err) {
            this.exitWithError("Unknown user.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (roles.isEmpty()) {
            this.printInformation("The user has no roles.");
        } else {
            this.printResults(String.join((CharSequence)",", roles));
        }
    }
}

