/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.MetricRegistry;

public class WriterBufferMetric {
    private static final String GROUP_NAME = "writerBuffer";
    private static final String BUFFER_PREEMPT_COUNT = "bufferPreemptCount";
    private static final String USED_WRITE_BUFFER_SIZE = "usedWriteBufferSizeByte";
    private static final String TOTAL_WRITE_BUFFER_SIZE = "totalWriteBufferSizeByte";
    private final MetricGroup metricGroup;

    public WriterBufferMetric(Supplier<MemoryPoolFactory> memoryPoolFactorySupplier, MetricRegistry metricRegistry, String tableName) {
        this.metricGroup = metricRegistry.tableMetricGroup(GROUP_NAME, tableName);
        this.metricGroup.gauge(BUFFER_PREEMPT_COUNT, () -> this.getMetricValue(memoryPoolFactorySupplier, MemoryPoolFactory::bufferPreemptCount));
        this.metricGroup.gauge(USED_WRITE_BUFFER_SIZE, () -> this.getMetricValue(memoryPoolFactorySupplier, MemoryPoolFactory::usedBufferSize));
        this.metricGroup.gauge(TOTAL_WRITE_BUFFER_SIZE, () -> this.getMetricValue(memoryPoolFactorySupplier, MemoryPoolFactory::totalBufferSize));
    }

    private long getMetricValue(Supplier<MemoryPoolFactory> memoryPoolFactorySupplier, Function<MemoryPoolFactory, Long> function) {
        MemoryPoolFactory memoryPoolFactory = memoryPoolFactorySupplier.get();
        return memoryPoolFactory == null ? -1L : function.apply(memoryPoolFactory);
    }

    public void close() {
        this.metricGroup.close();
    }
}

