/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.DecimalUtils;

class DecimalToNumericPrimitiveCastRule
extends AbstractCastRule<Decimal, Number> {
    static final DecimalToNumericPrimitiveCastRule INSTANCE = new DecimalToNumericPrimitiveCastRule();

    private DecimalToNumericPrimitiveCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.DECIMAL).target(DataTypeFamily.INTEGER_NUMERIC).target(DataTypeFamily.APPROXIMATE_NUMERIC).build());
    }

    @Override
    public CastExecutor<Decimal, Number> create(DataType inputType, DataType targetType) {
        switch (targetType.getTypeRoot()) {
            case TINYINT: {
                return value -> (byte)DecimalUtils.castToIntegral((Decimal)value);
            }
            case SMALLINT: {
                return value -> (short)DecimalUtils.castToIntegral((Decimal)value);
            }
            case INTEGER: {
                return value -> (int)DecimalUtils.castToIntegral((Decimal)value);
            }
            case BIGINT: {
                return DecimalUtils::castToIntegral;
            }
            case FLOAT: {
                return value -> Float.valueOf((float)DecimalUtils.doubleValue((Decimal)value));
            }
            case DOUBLE: {
                return DecimalUtils::doubleValue;
            }
        }
        return null;
    }
}

