/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.AbstractRowDataSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.RowBuffer;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.RowDataRollingFileWriter;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RecordWriter;

public class AppendOnlyWriter
implements RecordWriter<InternalRow>,
MemoryOwner {
    private final FileIO fileIO;
    private final long schemaId;
    private final FileFormat fileFormat;
    private final long targetFileSize;
    private final RowType writeSchema;
    private final DataFilePathFactory pathFactory;
    private final CompactManager compactManager;
    private final AppendOnlyFileStoreWrite.BucketFileRead bucketFileRead;
    private final boolean forceCompact;
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> deletedFiles;
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;
    private final LongCounter seqNumCounter;
    private final String fileCompression;
    private final String spillCompression;
    private SinkWriter sinkWriter;
    private final FieldStatsCollector.Factory[] statsCollectors;
    private final IOManager ioManager;
    private final FileIndexOptions fileIndexOptions;
    private MemorySegmentPool memorySegmentPool;
    private MemorySize maxDiskSize;

    public AppendOnlyWriter(FileIO fileIO, IOManager ioManager, long schemaId, FileFormat fileFormat, long targetFileSize, RowType writeSchema, long maxSequenceNumber, CompactManager compactManager, AppendOnlyFileStoreWrite.BucketFileRead bucketFileRead, boolean forceCompact, DataFilePathFactory pathFactory, @Nullable CommitIncrement increment, boolean useWriteBuffer, boolean spillable, String fileCompression, String spillCompression, FieldStatsCollector.Factory[] statsCollectors, MemorySize maxDiskSize, FileIndexOptions fileIndexOptions) {
        this.fileIO = fileIO;
        this.schemaId = schemaId;
        this.fileFormat = fileFormat;
        this.targetFileSize = targetFileSize;
        this.writeSchema = writeSchema;
        this.pathFactory = pathFactory;
        this.compactManager = compactManager;
        this.bucketFileRead = bucketFileRead;
        this.forceCompact = forceCompact;
        this.newFiles = new ArrayList<DataFileMeta>();
        this.deletedFiles = new ArrayList<DataFileMeta>();
        this.compactBefore = new ArrayList<DataFileMeta>();
        this.compactAfter = new ArrayList<DataFileMeta>();
        this.seqNumCounter = new LongCounter(maxSequenceNumber + 1L);
        this.fileCompression = fileCompression;
        this.spillCompression = spillCompression;
        this.ioManager = ioManager;
        this.statsCollectors = statsCollectors;
        this.maxDiskSize = maxDiskSize;
        this.fileIndexOptions = fileIndexOptions;
        SinkWriter sinkWriter = this.sinkWriter = useWriteBuffer ? new BufferedSinkWriter(spillable, maxDiskSize, spillCompression) : new DirectSinkWriter();
        if (increment != null) {
            this.newFiles.addAll(increment.newFilesIncrement().newFiles());
            this.deletedFiles.addAll(increment.newFilesIncrement().deletedFiles());
            this.compactBefore.addAll(increment.compactIncrement().compactBefore());
            this.compactAfter.addAll(increment.compactIncrement().compactAfter());
        }
    }

    @Override
    public void write(InternalRow rowData) throws Exception {
        Preconditions.checkArgument((boolean)rowData.getRowKind().isAdd(), (String)"Append-only writer can only accept insert or update_after row kind, but current row kind is: %s. You can configure 'ignore-delete' to ignore retract records.", (Object[])new Object[]{rowData.getRowKind()});
        boolean success = this.sinkWriter.write(rowData);
        if (!success) {
            this.flush(false, false);
            success = this.sinkWriter.write(rowData);
            if (!success) {
                throw new RuntimeException("Mem table is too small to hold a single element.");
            }
        }
    }

    @Override
    public void compact(boolean fullCompaction) throws Exception {
        this.flush(true, fullCompaction);
    }

    @Override
    public void addNewFiles(List<DataFileMeta> files) {
        files.forEach(this.compactManager::addNewFile);
    }

    @Override
    public Collection<DataFileMeta> dataFiles() {
        return this.compactManager.allFiles();
    }

    @Override
    public CommitIncrement prepareCommit(boolean waitCompaction) throws Exception {
        this.flush(false, false);
        this.trySyncLatestCompaction(waitCompaction || this.forceCompact);
        return this.drainIncrement();
    }

    @Override
    public boolean isCompacting() {
        return this.compactManager.isCompacting();
    }

    @VisibleForTesting
    void flush(boolean waitForLatestCompaction, boolean forcedFullCompaction) throws Exception {
        List<DataFileMeta> flushedFiles = this.sinkWriter.flush();
        flushedFiles.forEach(this.compactManager::addNewFile);
        this.trySyncLatestCompaction(waitForLatestCompaction);
        this.compactManager.triggerCompaction(forcedFullCompaction);
        this.newFiles.addAll(flushedFiles);
    }

    @Override
    public void sync() throws Exception {
        this.trySyncLatestCompaction(true);
    }

    @Override
    public void close() throws Exception {
        this.compactManager.cancelCompaction();
        this.sync();
        this.compactManager.close();
        for (DataFileMeta file : this.compactAfter) {
            this.fileIO.deleteQuietly(this.pathFactory.toPath(file.fileName()));
        }
        this.sinkWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBufferedWriter() throws Exception {
        if (this.sinkWriter != null && !this.sinkWriter.bufferSpillableWriter() && this.bucketFileRead != null) {
            List<DataFileMeta> files = this.sinkWriter.flush();
            this.sinkWriter.close();
            this.sinkWriter = new BufferedSinkWriter(true, this.maxDiskSize, this.spillCompression);
            this.sinkWriter.setMemoryPool(this.memorySegmentPool);
            try (RecordReaderIterator<InternalRow> reader = this.bucketFileRead.read(files);){
                while (reader.hasNext()) {
                    this.sinkWriter.write((InternalRow)reader.next());
                }
            }
            finally {
                for (DataFileMeta file : files) {
                    this.fileIO.deleteQuietly(this.pathFactory.toPath(file.fileName()));
                }
            }
        }
    }

    private RowDataRollingFileWriter createRollingRowWriter() {
        return new RowDataRollingFileWriter(this.fileIO, this.schemaId, this.fileFormat, this.targetFileSize, this.writeSchema, this.pathFactory, this.seqNumCounter, this.fileCompression, this.statsCollectors, this.fileIndexOptions);
    }

    private void trySyncLatestCompaction(boolean blocking) throws ExecutionException, InterruptedException {
        this.compactManager.getCompactionResult(blocking).ifPresent(result -> {
            this.compactBefore.addAll(result.before());
            this.compactAfter.addAll(result.after());
        });
    }

    private CommitIncrement drainIncrement() {
        DataIncrement dataIncrement = new DataIncrement(new ArrayList<DataFileMeta>(this.newFiles), new ArrayList<DataFileMeta>(this.deletedFiles), Collections.emptyList());
        CompactIncrement compactIncrement = new CompactIncrement(new ArrayList<DataFileMeta>(this.compactBefore), new ArrayList<DataFileMeta>(this.compactAfter), Collections.emptyList());
        this.newFiles.clear();
        this.deletedFiles.clear();
        this.compactBefore.clear();
        this.compactAfter.clear();
        return new CommitIncrement(dataIncrement, compactIncrement);
    }

    @Override
    public void setMemoryPool(MemorySegmentPool memoryPool) {
        this.memorySegmentPool = memoryPool;
        this.sinkWriter.setMemoryPool(memoryPool);
    }

    @Override
    public long memoryOccupancy() {
        return this.sinkWriter.memoryOccupancy();
    }

    @Override
    public void flushMemory() throws Exception {
        boolean success = this.sinkWriter.flushMemory();
        if (!success) {
            this.flush(false, false);
        }
    }

    @VisibleForTesting
    public RowBuffer getWriteBuffer() {
        if (this.sinkWriter instanceof BufferedSinkWriter) {
            return ((BufferedSinkWriter)this.sinkWriter).writeBuffer;
        }
        return null;
    }

    @VisibleForTesting
    List<DataFileMeta> getNewFiles() {
        return this.newFiles;
    }

    private class BufferedSinkWriter
    implements SinkWriter {
        private final boolean spillable;
        private final MemorySize maxDiskSize;
        private final String compression;
        private RowBuffer writeBuffer;

        private BufferedSinkWriter(boolean spillable, MemorySize maxDiskSize, String compression) {
            this.spillable = spillable;
            this.maxDiskSize = maxDiskSize;
            this.compression = compression;
        }

        @Override
        public boolean write(InternalRow data) throws IOException {
            return this.writeBuffer.put(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DataFileMeta> flush() throws IOException {
            ArrayList<DataFileMeta> flushedFiles = new ArrayList<DataFileMeta>();
            if (this.writeBuffer != null) {
                this.writeBuffer.complete();
                RowDataRollingFileWriter writer = AppendOnlyWriter.this.createRollingRowWriter();
                IOException exception = null;
                try (RowBuffer.RowBufferIterator iterator = this.writeBuffer.newIterator();){
                    while (iterator.advanceNext()) {
                        writer.write(iterator.getRow());
                    }
                }
                catch (IOException e) {
                    exception = e;
                }
                finally {
                    if (exception != null) {
                        IOUtils.closeQuietly((AutoCloseable)writer);
                        throw exception;
                    }
                    writer.close();
                }
                flushedFiles.addAll((Collection<DataFileMeta>)writer.result());
                this.writeBuffer.reset();
            }
            return flushedFiles;
        }

        @Override
        public long memoryOccupancy() {
            return this.writeBuffer.memoryOccupancy();
        }

        @Override
        public void close() {
            if (this.writeBuffer != null) {
                this.writeBuffer.reset();
                this.writeBuffer = null;
            }
        }

        @Override
        public void setMemoryPool(MemorySegmentPool memoryPool) {
            this.writeBuffer = RowBuffer.getBuffer(AppendOnlyWriter.this.ioManager, memoryPool, (AbstractRowDataSerializer<InternalRow>)new InternalRowSerializer(AppendOnlyWriter.this.writeSchema), this.spillable, this.maxDiskSize, this.compression);
        }

        @Override
        public boolean bufferSpillableWriter() {
            return this.spillable;
        }

        @Override
        public boolean flushMemory() throws IOException {
            return this.writeBuffer.flushMemory();
        }
    }

    private class DirectSinkWriter
    implements SinkWriter {
        private RowDataRollingFileWriter writer;

        private DirectSinkWriter() {
        }

        @Override
        public boolean write(InternalRow data) throws IOException {
            if (this.writer == null) {
                this.writer = AppendOnlyWriter.this.createRollingRowWriter();
            }
            this.writer.write(data);
            return true;
        }

        @Override
        public List<DataFileMeta> flush() throws IOException {
            ArrayList<DataFileMeta> flushedFiles = new ArrayList<DataFileMeta>();
            if (this.writer != null) {
                this.writer.close();
                flushedFiles.addAll((Collection<DataFileMeta>)this.writer.result());
                this.writer = null;
            }
            return flushedFiles;
        }

        @Override
        public boolean flushMemory() throws IOException {
            return false;
        }

        @Override
        public long memoryOccupancy() {
            return 0L;
        }

        @Override
        public void close() {
            if (this.writer != null) {
                this.writer.abort();
                this.writer = null;
            }
        }

        @Override
        public void setMemoryPool(MemorySegmentPool memoryPool) {
        }

        @Override
        public boolean bufferSpillableWriter() {
            return false;
        }
    }

    private static interface SinkWriter {
        public boolean write(InternalRow var1) throws IOException;

        public List<DataFileMeta> flush() throws IOException;

        public boolean flushMemory() throws IOException;

        public long memoryOccupancy();

        public void close();

        public void setMemoryPool(MemorySegmentPool var1);

        public boolean bufferSpillableWriter();
    }
}

