/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.credential;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.Map;
import org.apache.gravitino.credential.Credential;

public class CredentialDTO
implements Credential {
    @JsonProperty(value="credentialType")
    private String credentialType;
    @JsonProperty(value="expireTimeInMs")
    private long expireTimeInMs;
    @JsonProperty(value="credentialInfo")
    private Map<String, String> credentialInfo;

    private CredentialDTO() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CredentialDTO)) {
            return false;
        }
        CredentialDTO credentialDTO = (CredentialDTO)o;
        return Objects.equal((Object)this.credentialType, (Object)credentialDTO.credentialType) && Objects.equal((Object)this.expireTimeInMs, (Object)credentialDTO.expireTimeInMs) && Objects.equal(this.credentialInfo, credentialDTO.credentialInfo);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.credentialType, this.expireTimeInMs, this.credentialInfo});
    }

    public String credentialType() {
        return this.credentialType;
    }

    public long expireTimeInMs() {
        return this.expireTimeInMs;
    }

    public Map<String, String> credentialInfo() {
        return this.credentialInfo;
    }

    public void initialize(Map<String, String> credentialInfo, long expireTimeInMs) {
        throw new UnsupportedOperationException("CredentialDTO doesn't support initWithCredentialInfo");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CredentialDTO credentialDTO = new CredentialDTO();

        private Builder() {
        }

        public Builder withCredentialType(String credentialType) {
            this.credentialDTO.credentialType = credentialType;
            return this;
        }

        public Builder withExpireTimeInMs(long expireTimeInMs) {
            this.credentialDTO.expireTimeInMs = expireTimeInMs;
            return this;
        }

        public Builder withCredentialInfo(Map<String, String> credentialInfo) {
            this.credentialDTO.credentialInfo = credentialInfo;
            return this;
        }

        public CredentialDTO build() {
            return this.credentialDTO;
        }
    }
}

