/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.converter;

import java.time.format.DateTimeFormatter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.types.Type;

public class JdbcColumnDefaultValueConverter {
    protected static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    protected static final String NULL = "NULL";
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public String fromGravitino(Expression defaultValue) {
        if (Column.DEFAULT_VALUE_NOT_SET.equals(defaultValue)) {
            return null;
        }
        if (defaultValue instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)defaultValue;
            if (functionExpression.functionName().equalsIgnoreCase(CURRENT_TIMESTAMP)) {
                return CURRENT_TIMESTAMP;
            }
            return String.format("(%s)", functionExpression);
        }
        if (defaultValue instanceof Literal) {
            Literal literal = (Literal)defaultValue;
            Type type = literal.dataType();
            if (defaultValue.equals(Literals.NULL)) {
                return NULL;
            }
            if (type instanceof Type.NumericType) {
                return literal.value().toString();
            }
            return String.format("'%s'", literal.value());
        }
        throw new IllegalArgumentException("Not a supported column default value: " + defaultValue);
    }

    public Expression toGravitino(JdbcTypeConverter.JdbcTypeBean columnType, String columnDefaultValue, boolean isExpression, boolean nullable) {
        return Column.DEFAULT_VALUE_NOT_SET;
    }
}

