/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;

public final class AuditInfo
implements Audit,
Entity {
    public static final Field CREATOR = Field.optional("creator", String.class, "The name of the user who created the entity");
    public static final Field CREATE_TIME = Field.optional("create_time", Instant.class, "The time when the entity was created");
    public static final Field LAST_MODIFIER = Field.optional("last_modifier", String.class, "The name of the user who last modified the entity");
    public static final Field LAST_MODIFIED_TIME = Field.optional("last_modified_time", Instant.class, "The time when the entity was last modified");
    public static final AuditInfo EMPTY = AuditInfo.builder().build();
    @Nullable
    private String creator;
    @Nullable
    private Instant createTime;
    @Nullable
    private String lastModifier;
    @Nullable
    private Instant lastModifiedTime;

    public static Builder builder() {
        return new Builder();
    }

    private AuditInfo() {
    }

    @Override
    public void validate() throws IllegalArgumentException {
        CREATOR.validate(this.creator);
        CREATE_TIME.validate(this.createTime);
        LAST_MODIFIER.validate(this.lastModifier);
        LAST_MODIFIED_TIME.validate(this.lastModifiedTime);
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap<Field, Object> fields = new HashMap<Field, Object>();
        fields.put(CREATOR, this.creator);
        fields.put(CREATE_TIME, this.createTime);
        fields.put(LAST_MODIFIER, this.lastModifier);
        fields.put(LAST_MODIFIED_TIME, this.lastModifiedTime);
        return Collections.unmodifiableMap(fields);
    }

    public String creator() {
        return this.creator;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public String lastModifier() {
        return this.lastModifier;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.AUDIT;
    }

    public AuditInfo merge(AuditInfo other, boolean overwrite) {
        if (other == null) {
            return this;
        }
        this.creator = overwrite || this.creator == null ? other.creator : this.creator;
        this.createTime = overwrite || this.createTime == null ? other.createTime : this.createTime;
        this.lastModifier = overwrite || this.lastModifier == null ? other.lastModifier : this.lastModifier;
        this.lastModifiedTime = overwrite || this.lastModifiedTime == null ? other.lastModifiedTime : this.lastModifiedTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditInfo)) {
            return false;
        }
        AuditInfo other = (AuditInfo)o;
        String this$creator = this.creator;
        String other$creator = other.creator;
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Instant this$createTime = this.createTime;
        Instant other$createTime = other.createTime;
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$lastModifier = this.lastModifier;
        String other$lastModifier = other.lastModifier;
        if (this$lastModifier == null ? other$lastModifier != null : !this$lastModifier.equals(other$lastModifier)) {
            return false;
        }
        Instant this$lastModifiedTime = this.lastModifiedTime;
        Instant other$lastModifiedTime = other.lastModifiedTime;
        return !(this$lastModifiedTime == null ? other$lastModifiedTime != null : !((Object)this$lastModifiedTime).equals(other$lastModifiedTime));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $creator = this.creator;
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Instant $createTime = this.createTime;
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $lastModifier = this.lastModifier;
        result = result * 59 + ($lastModifier == null ? 43 : $lastModifier.hashCode());
        Instant $lastModifiedTime = this.lastModifiedTime;
        result = result * 59 + ($lastModifiedTime == null ? 43 : ((Object)$lastModifiedTime).hashCode());
        return result;
    }

    public String toString() {
        return "AuditInfo(creator=" + this.creator + ", createTime=" + this.createTime + ", lastModifier=" + this.lastModifier + ", lastModifiedTime=" + this.lastModifiedTime + ")";
    }

    public static class Builder {
        private AuditInfo auditInfo = new AuditInfo();

        private Builder() {
        }

        public Builder withCreator(String creator) {
            this.auditInfo.creator = creator;
            return this;
        }

        public Builder withCreateTime(Instant createTime) {
            this.auditInfo.createTime = createTime;
            return this;
        }

        public Builder withLastModifier(String lastModifier) {
            this.auditInfo.lastModifier = lastModifier;
            return this;
        }

        public Builder withLastModifiedTime(Instant lastModifiedTime) {
            this.auditInfo.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public AuditInfo build() {
            this.auditInfo.validate();
            return this.auditInfo;
        }
    }
}

