/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.ibatis.annotations.Param;

public class ModelMetaBaseSQLProvider {
    public String insertModelMeta(@Param(value="modelMeta") ModelPO modelPO) {
        return "INSERT INTO model_meta (model_id, model_name, metalake_id, catalog_id, schema_id, model_comment, model_properties, model_latest_version, audit_info, deleted_at) VALUES (#{modelMeta.modelId}, #{modelMeta.modelName}, #{modelMeta.metalakeId}, #{modelMeta.catalogId}, #{modelMeta.schemaId}, #{modelMeta.modelComment}, #{modelMeta.modelProperties}, #{modelMeta.modelLatestVersion}, #{modelMeta.auditInfo}, #{modelMeta.deletedAt})";
    }

    public String insertModelMetaOnDuplicateKeyUpdate(@Param(value="modelMeta") ModelPO modelPO) {
        return "INSERT INTO model_meta (model_id, model_name, metalake_id, catalog_id, schema_id, model_comment, model_properties, model_latest_version, audit_info, deleted_at) VALUES (#{modelMeta.modelId}, #{modelMeta.modelName}, #{modelMeta.metalakeId}, #{modelMeta.catalogId}, #{modelMeta.schemaId}, #{modelMeta.modelComment}, #{modelMeta.modelProperties}, #{modelMeta.modelLatestVersion}, #{modelMeta.auditInfo}, #{modelMeta.deletedAt}) ON DUPLICATE KEY UPDATE model_name = #{modelMeta.modelName}, metalake_id = #{modelMeta.metalakeId}, catalog_id = #{modelMeta.catalogId}, schema_id = #{modelMeta.schemaId}, model_comment = #{modelMeta.modelComment}, model_properties = #{modelMeta.modelProperties}, model_latest_version = #{modelMeta.modelLatestVersion}, audit_info = #{modelMeta.auditInfo}, deleted_at = #{modelMeta.deletedAt}";
    }

    public String listModelPOsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "SELECT model_id AS modelId, model_name AS modelName, metalake_id AS metalakeId, catalog_id AS catalogId, schema_id AS schemaId, model_comment AS modelComment, model_properties AS modelProperties, model_latest_version AS modelLatestVersion, audit_info AS auditInfo, deleted_at AS deletedAt FROM model_meta WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String selectModelMetaBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return "SELECT model_id AS modelId, model_name AS modelName, metalake_id AS metalakeId, catalog_id AS catalogId, schema_id AS schemaId, model_comment AS modelComment, model_properties AS modelProperties, model_latest_version AS modelLatestVersion, audit_info AS auditInfo, deleted_at AS deletedAt FROM model_meta WHERE schema_id = #{schemaId} AND model_name = #{modelName} AND deleted_at = 0";
    }

    public String selectModelIdBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return "SELECT model_id FROM model_meta WHERE schema_id = #{schemaId} AND model_name = #{modelName} AND deleted_at = 0";
    }

    public String selectModelMetaByModelId(@Param(value="modelId") Long modelId) {
        return "SELECT model_id AS modelId, model_name AS modelName, metalake_id AS metalakeId, catalog_id AS catalogId, schema_id AS schemaId, model_comment AS modelComment, model_properties AS modelProperties, model_latest_version AS  modelLatestVersion, audit_info AS auditInfo, deleted_at AS deletedAt FROM model_meta WHERE model_id = #{modelId} AND deleted_at = 0";
    }

    public String softDeleteModelMetaBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return "UPDATE model_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND model_name = #{modelName} AND deleted_at = 0";
    }

    public String softDeleteModelMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE model_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    public String softDeleteModelMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE model_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String softDeleteModelMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE model_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String deleteModelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM model_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    public String updateModelLatestVersion(@Param(value="modelId") Long modelId) {
        return "UPDATE model_meta SET model_latest_version = model_latest_version + 1 WHERE model_id = #{modelId} AND deleted_at = 0";
    }
}

