/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergTableOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;

public class IcebergTableOperationExecutor
implements IcebergTableOperationDispatcher {
    private IcebergCatalogWrapperManager icebergCatalogWrapperManager;

    public IcebergTableOperationExecutor(IcebergCatalogWrapperManager icebergCatalogWrapperManager) {
        this.icebergCatalogWrapperManager = icebergCatalogWrapperManager;
    }

    @Override
    public LoadTableResponse createTable(IcebergRequestContext context, Namespace namespace, CreateTableRequest createTableRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).createTable(namespace, createTableRequest, context.requestCredentialVending());
    }

    @Override
    public LoadTableResponse updateTable(IcebergRequestContext context, TableIdentifier tableIdentifier, UpdateTableRequest updateTableRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).updateTable(tableIdentifier, updateTableRequest);
    }

    @Override
    public void dropTable(IcebergRequestContext context, TableIdentifier tableIdentifier, boolean purgeRequested) {
        if (purgeRequested) {
            this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).purgeTable(tableIdentifier);
        } else {
            this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).dropTable(tableIdentifier);
        }
    }

    @Override
    public LoadTableResponse loadTable(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).loadTable(tableIdentifier, context.requestCredentialVending());
    }

    @Override
    public ListTablesResponse listTable(IcebergRequestContext context, Namespace namespace) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).listTable(namespace);
    }

    @Override
    public boolean tableExists(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).tableExists(tableIdentifier);
    }

    @Override
    public void renameTable(IcebergRequestContext context, RenameTableRequest renameTableRequest) {
        this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).renameTable(renameTableRequest);
    }
}

