/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.connector.BaseCatalog;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.exceptions.IllegalPrivilegeException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationUtils.class);
    static final String USER_DOES_NOT_EXIST_MSG = "User %s does not exist in the metalake %s";
    static final String GROUP_DOES_NOT_EXIST_MSG = "Group %s does not exist in the metalake %s";
    static final String ROLE_DOES_NOT_EXIST_MSG = "Role %s does not exist in the metalake %s";
    private static final Set<Privilege.Name> FILESET_PRIVILEGES = Sets.immutableEnumSet((Enum)Privilege.Name.CREATE_FILESET, (Enum[])new Privilege.Name[]{Privilege.Name.WRITE_FILESET, Privilege.Name.READ_FILESET});
    private static final Set<Privilege.Name> TABLE_PRIVILEGES = Sets.immutableEnumSet((Enum)Privilege.Name.CREATE_TABLE, (Enum[])new Privilege.Name[]{Privilege.Name.MODIFY_TABLE, Privilege.Name.SELECT_TABLE});
    private static final Set<Privilege.Name> TOPIC_PRIVILEGES = Sets.immutableEnumSet((Enum)Privilege.Name.CREATE_TOPIC, (Enum[])new Privilege.Name[]{Privilege.Name.PRODUCE_TOPIC, Privilege.Name.CONSUME_TOPIC});

    private AuthorizationUtils() {
    }

    public static void checkCurrentUser(String metalake, String user) {
        try {
            AccessControlDispatcher dispatcher = GravitinoEnv.getInstance().accessControlDispatcher();
            if (dispatcher != null) {
                dispatcher.getUser(metalake, user);
            }
        }
        catch (NoSuchUserException nsu) {
            throw new ForbiddenException("Current user %s doesn't exist in the metalake %s, you should add the user to the metalake first", new Object[]{user, metalake});
        }
    }

    public static NameIdentifier ofRole(String metalake, String role) {
        return NameIdentifier.of((String[])new String[]{metalake, "system", "role", role});
    }

    public static NameIdentifier ofGroup(String metalake, String group) {
        return NameIdentifier.of((String[])new String[]{metalake, "system", "group", group});
    }

    public static NameIdentifier ofUser(String metalake, String user) {
        return NameIdentifier.of((String[])new String[]{metalake, "system", "user", user});
    }

    public static Namespace ofRoleNamespace(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "role"});
    }

    public static Namespace ofGroupNamespace(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "group"});
    }

    public static Namespace ofUserNamespace(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "user"});
    }

    public static void checkUser(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"User identifier must not be null", (Object[])new Object[0]);
        AuthorizationUtils.checkUserNamespace(ident.namespace());
    }

    public static void checkGroup(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Group identifier must not be null", (Object[])new Object[0]);
        AuthorizationUtils.checkGroupNamespace(ident.namespace());
    }

    public static void checkRole(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Role identifier must not be null", (Object[])new Object[0]);
        AuthorizationUtils.checkRoleNamespace(ident.namespace());
    }

    public static void checkUserNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 3 ? 1 : 0) != 0, (String)"User namespace must have 3 levels, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    public static void checkGroupNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 3 ? 1 : 0) != 0, (String)"Group namespace must have 3 levels, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    public static void checkRoleNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 3 ? 1 : 0) != 0, (String)"Role namespace must have 3 levels, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    public static void callAuthorizationPluginForSecurableObjects(String metalake, List<SecurableObject> securableObjects, BiConsumer<AuthorizationPlugin, String> consumer) {
        HashSet catalogsAlreadySet = Sets.newHashSet();
        CatalogManager catalogManager = GravitinoEnv.getInstance().catalogManager();
        for (SecurableObject securableObject : securableObjects) {
            NameIdentifier catalogIdent;
            Catalog catalog;
            if (AuthorizationUtils.needApplyAuthorizationPluginAllCatalogs(securableObject)) {
                NameIdentifier[] catalogs;
                for (NameIdentifier catalog2 : catalogs = catalogManager.listCatalogs(Namespace.of((String[])new String[]{metalake}))) {
                    AuthorizationUtils.callAuthorizationPluginImpl(consumer, catalogManager.loadCatalog(catalog2));
                }
                continue;
            }
            if (!AuthorizationUtils.needApplyAuthorization(securableObject.type()) || catalogsAlreadySet.contains((catalog = catalogManager.loadCatalog(catalogIdent = NameIdentifierUtil.getCatalogIdentifier(MetadataObjectUtil.toEntityIdent(metalake, (MetadataObject)securableObject)))).name())) continue;
            catalogsAlreadySet.add(catalog.name());
            AuthorizationUtils.callAuthorizationPluginImpl(consumer, catalog);
        }
    }

    public static void callAuthorizationPluginForMetadataObject(String metalake, MetadataObject metadataObject, Consumer<AuthorizationPlugin> consumer) {
        List<Catalog> loadedCatalogs = AuthorizationUtils.loadMetadataObjectCatalog(metalake, metadataObject);
        for (Catalog catalog : loadedCatalogs) {
            AuthorizationUtils.callAuthorizationPluginImpl(consumer, catalog);
        }
    }

    public static boolean needApplyAuthorizationPluginAllCatalogs(SecurableObject securableObject) {
        if (securableObject.type() == MetadataObject.Type.METALAKE) {
            List privileges = securableObject.privileges();
            for (Privilege privilege : privileges) {
                if (!privilege.canBindTo(MetadataObject.Type.CATALOG)) continue;
                return true;
            }
        }
        return false;
    }

    public static void checkDuplicatedNamePrivilege(Collection<Privilege> privileges) {
        HashSet privilegeNameSet = Sets.newHashSet();
        for (Privilege privilege : privileges) {
            if (privilegeNameSet.contains(privilege.name())) {
                throw new IllegalPrivilegeException("Doesn't support duplicated privilege name %s with different condition", new Object[]{privilege.name()});
            }
            privilegeNameSet.add(privilege.name());
        }
    }

    public static void checkPrivilege(PrivilegeDTO privilegeDTO, MetadataObject object, String metalake) {
        Privilege privilege = DTOConverters.fromPrivilegeDTO((PrivilegeDTO)privilegeDTO);
        if (!privilege.canBindTo(object.type())) {
            throw new IllegalPrivilegeException("Securable object %s type %s don't support binding privilege %s", new Object[]{object.fullName(), object.type(), privilege});
        }
        if (object.type() == MetadataObject.Type.CATALOG || object.type() == MetadataObject.Type.SCHEMA) {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, object);
            NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(identifier);
            try {
                if (FILESET_PRIVILEGES.contains(privilege.name())) {
                    AuthorizationUtils.checkCatalogType(catalogIdent, Catalog.Type.FILESET, privilege);
                }
                if (TABLE_PRIVILEGES.contains(privilege.name())) {
                    AuthorizationUtils.checkCatalogType(catalogIdent, Catalog.Type.RELATIONAL, privilege);
                }
                if (TOPIC_PRIVILEGES.contains(privilege.name())) {
                    AuthorizationUtils.checkCatalogType(catalogIdent, Catalog.Type.MESSAGING, privilege);
                }
            }
            catch (NoSuchCatalogException ne) {
                throw new NoSuchMetadataObjectException("Securable object %s doesn't exist", new Object[]{object.fullName()});
            }
        }
    }

    public static void authorizationPluginRemovePrivileges(NameIdentifier ident, Entity.EntityType type, List<String> locations) {
        if (GravitinoEnv.getInstance().accessControlDispatcher() != null) {
            MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(ident, type);
            String metalake = type == Entity.EntityType.METALAKE ? ident.name() : ident.namespace().level(0);
            MetadataObjectChange removeObject = MetadataObjectChange.remove((MetadataObject)metadataObject, locations);
            AuthorizationUtils.callAuthorizationPluginForMetadataObject(metalake, metadataObject, authorizationPlugin -> authorizationPlugin.onMetadataUpdated(removeObject));
        }
    }

    public static void removeCatalogPrivileges(Catalog catalog, List<String> locations) {
        MetadataObject metadataObject = MetadataObjects.of(null, (String)catalog.name(), (MetadataObject.Type)MetadataObject.Type.CATALOG);
        MetadataObjectChange removeObject = MetadataObjectChange.remove((MetadataObject)metadataObject, locations);
        AuthorizationUtils.callAuthorizationPluginImpl((AuthorizationPlugin authorizationPlugin) -> authorizationPlugin.onMetadataUpdated(removeObject), catalog);
    }

    public static void authorizationPluginRenamePrivileges(NameIdentifier ident, Entity.EntityType type, String newName) {
        if (GravitinoEnv.getInstance().accessControlDispatcher() != null) {
            MetadataObject oldMetadataObject = NameIdentifierUtil.toMetadataObject(ident, type);
            MetadataObject newMetadataObject = NameIdentifierUtil.toMetadataObject(NameIdentifier.of((Namespace)ident.namespace(), (String)newName), type);
            MetadataObjectChange renameObject = MetadataObjectChange.rename((MetadataObject)oldMetadataObject, (MetadataObject)newMetadataObject);
            String metalake = type == Entity.EntityType.METALAKE ? newName : ident.namespace().level(0);
            AuthorizationUtils.callAuthorizationPluginForMetadataObject(metalake, newMetadataObject, authorizationPlugin -> authorizationPlugin.onMetadataUpdated(renameObject));
        }
    }

    public static Role filterSecurableObjects(RoleEntity role, String metalakeName, String catalogName) {
        List<SecurableObject> securableObjects = role.securableObjects();
        ArrayList filteredSecurableObjects = Lists.newArrayList();
        for (SecurableObject securableObject : securableObjects) {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalakeName, (MetadataObject)securableObject);
            if (securableObject.type() == MetadataObject.Type.METALAKE) {
                filteredSecurableObjects.add(securableObject);
                continue;
            }
            NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(identifier);
            if (!catalogIdent.name().equals(catalogName)) continue;
            filteredSecurableObjects.add(securableObject);
        }
        return RoleEntity.builder().withId(role.id()).withName(role.name()).withAuditInfo(role.auditInfo()).withNamespace(role.namespace()).withSecurableObjects(filteredSecurableObjects).withProperties(role.properties()).build();
    }

    private static boolean needApplyAuthorizationPluginAllCatalogs(MetadataObject.Type type) {
        return type == MetadataObject.Type.METALAKE;
    }

    private static boolean needApplyAuthorization(MetadataObject.Type type) {
        return type != MetadataObject.Type.ROLE && type != MetadataObject.Type.METALAKE;
    }

    private static void callAuthorizationPluginImpl(BiConsumer<AuthorizationPlugin, String> consumer, Catalog catalog) {
        if (catalog instanceof BaseCatalog) {
            BaseCatalog baseCatalog = (BaseCatalog)catalog;
            if (baseCatalog.getAuthorizationPlugin() != null) {
                consumer.accept(baseCatalog.getAuthorizationPlugin(), catalog.name());
            }
        } else {
            throw new IllegalArgumentException(String.format("Catalog %s is not a BaseCatalog, we don't support authorization plugin for it", catalog.type()));
        }
    }

    private static void callAuthorizationPluginImpl(Consumer<AuthorizationPlugin> consumer, Catalog catalog) {
        if (catalog instanceof BaseCatalog) {
            BaseCatalog baseCatalog = (BaseCatalog)catalog;
            if (baseCatalog.getAuthorizationPlugin() != null) {
                consumer.accept(baseCatalog.getAuthorizationPlugin());
            }
        } else {
            throw new IllegalArgumentException(String.format("Catalog %s is not a BaseCatalog, we don't support authorization plugin for it", catalog.type()));
        }
    }

    private static void checkCatalogType(NameIdentifier catalogIdent, Catalog.Type type, Privilege privilege) {
        Catalog catalog = GravitinoEnv.getInstance().catalogDispatcher().loadCatalog(catalogIdent);
        if (catalog.type() != type) {
            throw new IllegalPrivilegeException("Catalog %s type %s doesn't support privilege %s", new Object[]{catalogIdent, catalog.type(), privilege});
        }
    }

    private static List<Catalog> loadMetadataObjectCatalog(String metalake, MetadataObject metadataObject) {
        CatalogManager catalogManager = GravitinoEnv.getInstance().catalogManager();
        ArrayList loadedCatalogs = Lists.newArrayList();
        if (AuthorizationUtils.needApplyAuthorizationPluginAllCatalogs(metadataObject.type())) {
            NameIdentifier[] catalogs;
            for (NameIdentifier catalog : catalogs = catalogManager.listCatalogs(Namespace.of((String[])new String[]{metalake}))) {
                loadedCatalogs.add(catalogManager.loadCatalog(catalog));
            }
        } else if (AuthorizationUtils.needApplyAuthorization(metadataObject.type())) {
            NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(MetadataObjectUtil.toEntityIdent(metalake, metadataObject));
            Catalog catalog = catalogManager.loadCatalog(catalogIdent);
            loadedCatalogs.add(catalog);
        }
        return loadedCatalogs;
    }

    private static String getHiveDefaultLocation(String metalakeName, String catalogName) {
        NameIdentifier defaultSchemaIdent = NameIdentifier.of((String[])new String[]{metalakeName, catalogName, "default"});
        Schema schema = GravitinoEnv.getInstance().schemaDispatcher().loadSchema(defaultSchemaIdent);
        if (schema.properties().containsKey("location")) {
            String defaultSchemaLocation = (String)schema.properties().get("location");
            if (defaultSchemaLocation != null && !defaultSchemaLocation.isEmpty()) {
                return defaultSchemaLocation;
            }
            LOG.warn("Schema %s location is not found", (Object)defaultSchemaIdent);
        }
        return null;
    }

    public static List<String> getMetadataObjectLocation(NameIdentifier ident, Entity.EntityType type) {
        ArrayList<String> locations = new ArrayList<String>();
        try {
            switch (type) {
                case METALAKE: {
                    NameIdentifier[] identifiers = GravitinoEnv.getInstance().catalogDispatcher().listCatalogs(Namespace.of((String[])new String[]{ident.name()}));
                    Arrays.stream(identifiers).collect(Collectors.toList()).forEach(identifier -> {
                        String defaultSchemaLocation;
                        Catalog catalogObj = GravitinoEnv.getInstance().catalogDispatcher().loadCatalog((NameIdentifier)identifier);
                        if (catalogObj.provider().equals("hive") && (defaultSchemaLocation = AuthorizationUtils.getHiveDefaultLocation(ident.name(), catalogObj.name())) != null && !defaultSchemaLocation.isEmpty()) {
                            locations.add(defaultSchemaLocation);
                        }
                    });
                    break;
                }
                case CATALOG: {
                    String defaultSchemaLocation;
                    Catalog catalogObj = GravitinoEnv.getInstance().catalogDispatcher().loadCatalog(ident);
                    if (catalogObj.provider().equals("hive") && (defaultSchemaLocation = AuthorizationUtils.getHiveDefaultLocation(ident.namespace().level(0), ident.name())) != null && !defaultSchemaLocation.isEmpty()) {
                        locations.add(defaultSchemaLocation);
                    }
                    break;
                }
                case SCHEMA: {
                    Schema schema;
                    Catalog catalogObj = GravitinoEnv.getInstance().catalogDispatcher().loadCatalog(NameIdentifier.of((String[])new String[]{ident.namespace().level(0), ident.namespace().level(1)}));
                    LOG.info("Catalog provider is %s", (Object)catalogObj.provider());
                    if (catalogObj.provider().equals("hive") && (schema = GravitinoEnv.getInstance().schemaDispatcher().loadSchema(ident)).properties().containsKey("location")) {
                        String schemaLocation = (String)schema.properties().get("location");
                        if (schemaLocation != null && schemaLocation.isEmpty()) {
                            locations.add(schemaLocation);
                            break;
                        }
                        LOG.warn("Schema %s location is not found", (Object)ident);
                    }
                    break;
                }
                case TABLE: {
                    Table table;
                    Catalog catalogObj = GravitinoEnv.getInstance().catalogDispatcher().loadCatalog(NameIdentifier.of((String[])new String[]{ident.namespace().level(0), ident.namespace().level(1)}));
                    if (catalogObj.provider().equals("hive") && (table = GravitinoEnv.getInstance().tableDispatcher().loadTable(ident)).properties().containsKey("location")) {
                        String tableLocation = (String)table.properties().get("location");
                        if (tableLocation != null && tableLocation.isEmpty()) {
                            locations.add(tableLocation);
                            break;
                        }
                        LOG.warn("Table %s location is not found", (Object)ident);
                    }
                    break;
                }
                case FILESET: {
                    FilesetDispatcher filesetDispatcher = GravitinoEnv.getInstance().filesetDispatcher();
                    Fileset fileset = filesetDispatcher.loadFileset(ident);
                    Preconditions.checkArgument((fileset != null ? 1 : 0) != 0, (Object)String.format("Fileset %s is not found", ident));
                    String filesetLocation = fileset.storageLocation();
                    Preconditions.checkArgument((filesetLocation != null ? 1 : 0) != 0, (Object)String.format("Fileset %s location is not found", ident));
                    locations.add(filesetLocation);
                    break;
                }
                default: {
                    throw new AuthorizationPluginException("Failed to get location paths for metadata object %s type %s", new Object[]{ident, type});
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get location paths for metadata object %s type %s", new Object[]{ident, type, e});
        }
        return locations;
    }

    private static NameIdentifier getObjectNameIdentifier(String metalake, MetadataObject metadataObject) {
        return NameIdentifier.parse((String)String.format("%s.%s", metalake, metadataObject.fullName()));
    }
}

