/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class S3TokenCredential
implements Credential {
    public static final String S3_TOKEN_CREDENTIAL_TYPE = "s3-token";
    public static final String GRAVITINO_S3_SESSION_ACCESS_KEY_ID = "s3-access-key-id";
    public static final String GRAVITINO_S3_SESSION_SECRET_ACCESS_KEY = "s3-secret-access-key";
    public static final String GRAVITINO_S3_TOKEN = "s3-session-token";
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final long expireTimeInMS;

    public S3TokenCredential(String accessKeyId, String secretAccessKey, String sessionToken, long expireTimeInMS) {
        Preconditions.checkArgument(StringUtils.isNotBlank(accessKeyId), "S3 access key Id should not be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(secretAccessKey), "S3 secret access key should not be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(sessionToken), "S3 session token should not be empty");
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expireTimeInMS = expireTimeInMS;
    }

    @Override
    public String credentialType() {
        return S3_TOKEN_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireTimeInMS;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder<String, String>().put(GRAVITINO_S3_SESSION_ACCESS_KEY_ID, this.accessKeyId).put(GRAVITINO_S3_SESSION_SECRET_ACCESS_KEY, this.secretAccessKey).put(GRAVITINO_S3_TOKEN, this.sessionToken).build();
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }
}

