/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.storage.kv.KvEntityStore;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnerManager {
    private static final Logger LOG = LoggerFactory.getLogger(OwnerManager.class);
    private final EntityStore store;

    public OwnerManager(EntityStore store) {
        if (store instanceof KvEntityStore) {
            String errorMsg = "OwnerManager cannot run with kv entity store, please configure the entity store to use relational entity store and restart the Gravitino server";
            LOG.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (!(store instanceof SupportsRelationOperations)) {
            String errorMsg = "OwnerManager currently only supports relational entity store, please configure the entity store to use relational entity store and restart the Gravitino server";
            LOG.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.store = store;
    }

    public void setOwner(String metalake, MetadataObject metadataObject, String ownerName, Owner.Type ownerType) {
        try {
            Optional<Owner> originOwner = this.getOwner(metalake, metadataObject);
            NameIdentifier objectIdent = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            OwnerImpl newOwner = new OwnerImpl();
            if (ownerType == Owner.Type.USER) {
                NameIdentifier ownerIdent = AuthorizationUtils.ofUser(metalake, ownerName);
                TreeLockUtils.doWithTreeLock(ownerIdent, LockType.READ, () -> {
                    this.store.relationOperations().insertRelation(SupportsRelationOperations.Type.OWNER_REL, objectIdent, MetadataObjectUtil.toEntityType(metadataObject), ownerIdent, Entity.EntityType.USER, true);
                    return null;
                });
                newOwner.name = ownerName;
                newOwner.type = Owner.Type.USER;
            } else if (ownerType == Owner.Type.GROUP) {
                NameIdentifier ownerIdent = AuthorizationUtils.ofGroup(metalake, ownerName);
                TreeLockUtils.doWithTreeLock(ownerIdent, LockType.READ, () -> {
                    this.store.relationOperations().insertRelation(SupportsRelationOperations.Type.OWNER_REL, objectIdent, MetadataObjectUtil.toEntityType(metadataObject), ownerIdent, Entity.EntityType.GROUP, true);
                    return null;
                });
                newOwner.name = ownerName;
                newOwner.type = Owner.Type.GROUP;
            }
            AuthorizationUtils.callAuthorizationPluginForMetadataObject(metalake, metadataObject, authorizationPlugin -> authorizationPlugin.onOwnerSet(metadataObject, originOwner.orElse(null), newOwner));
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Metadata object {} or owner {} is not found", new Object[]{metadataObject.fullName(), ownerName, nse});
            throw new NotFoundException((Throwable)nse, "Metadata object %s or owner %s is not found", new Object[]{metadataObject.fullName(), ownerName});
        }
        catch (IOException ioe) {
            LOG.info("Fail to set the owner {} of metadata object {}", new Object[]{ownerName, metadataObject.fullName(), ioe});
            throw new RuntimeException(ioe);
        }
    }

    public Optional<Owner> getOwner(String metalake, MetadataObject metadataObject) {
        try {
            OwnerImpl owner = new OwnerImpl();
            NameIdentifier ident = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            List entities = this.store.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.OWNER_REL, ident, MetadataObjectUtil.toEntityType(metadataObject));
            if (entities.isEmpty()) {
                return Optional.empty();
            }
            if (entities.size() != 1) {
                throw new IllegalStateException(String.format("The number of the owner %s must be 1", metadataObject.fullName()));
            }
            Entity entity = (Entity)entities.get(0);
            if (!(entity instanceof UserEntity) && !(entity instanceof GroupEntity)) {
                throw new IllegalArgumentException(String.format("Doesn't support owner entity class %s", ((Entity)entities.get(0)).getClass().getName()));
            }
            if (entities.get(0) instanceof UserEntity) {
                UserEntity user = (UserEntity)entities.get(0);
                owner.name = user.name();
                owner.type = Owner.Type.USER;
            } else if (entities.get(0) instanceof GroupEntity) {
                GroupEntity group = (GroupEntity)entities.get(0);
                owner.name = group.name();
                owner.type = Owner.Type.GROUP;
            }
            return Optional.of(owner);
        }
        catch (NoSuchEntityException nse) {
            throw new NoSuchMetadataObjectException("The metadata object of %s isn't found", new Object[]{metadataObject.fullName()});
        }
        catch (IOException ioe) {
            LOG.info("Fail to get the owner of entity {}", (Object)metadataObject.fullName(), (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    private static class OwnerImpl
    implements Owner {
        private String name;
        private Owner.Type type;

        private OwnerImpl() {
        }

        public String name() {
            return this.name;
        }

        public Owner.Type type() {
            return this.type;
        }
    }
}

