/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.ExceptionFactory;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.jdbc.EmbedXAConnection;

final class XAStatementControl
implements BrokeredStatementControl {
    private final EmbedXAConnection xaConnection;
    private final BrokeredConnection applicationConnection;
    BrokeredStatement applicationStatement;
    private EmbedConnection realConnection;
    private Statement realStatement;
    private PreparedStatement realPreparedStatement;
    private CallableStatement realCallableStatement;

    private XAStatementControl(EmbedXAConnection embedXAConnection) {
        this.xaConnection = embedXAConnection;
        this.realConnection = embedXAConnection.realConnection;
        this.applicationConnection = embedXAConnection.currentConnectionHandle;
    }

    XAStatementControl(EmbedXAConnection embedXAConnection, Statement statement) throws SQLException {
        this(embedXAConnection);
        this.realStatement = statement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this);
        ((EmbedStatement)statement).setApplicationStatement(this.applicationStatement);
    }

    XAStatementControl(EmbedXAConnection embedXAConnection, PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        this(embedXAConnection);
        this.realPreparedStatement = preparedStatement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this, string, object);
        ((EmbedStatement)((Object)preparedStatement)).setApplicationStatement(this.applicationStatement);
    }

    XAStatementControl(EmbedXAConnection embedXAConnection, CallableStatement callableStatement, String string) throws SQLException {
        this(embedXAConnection);
        this.realCallableStatement = callableStatement;
        this.applicationStatement = this.applicationConnection.newBrokeredStatement(this, string);
        ((EmbedStatement)((Object)callableStatement)).setApplicationStatement(this.applicationStatement);
    }

    public void closeRealStatement() throws SQLException {
        this.realStatement.close();
    }

    public void closeRealCallableStatement() throws SQLException {
        this.realCallableStatement.close();
    }

    public void closeRealPreparedStatement() throws SQLException {
        this.realPreparedStatement.close();
    }

    public Statement getRealStatement() throws SQLException {
        if (this.applicationConnection == this.xaConnection.currentConnectionHandle) {
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            Statement statement = this.applicationStatement.createDuplicateStatement(this.xaConnection.realConnection, this.realStatement);
            ((EmbedStatement)this.realStatement).transferBatch((EmbedStatement)statement);
            try {
                this.realStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realStatement = statement;
            this.realConnection = this.xaConnection.realConnection;
            ((EmbedStatement)this.realStatement).setApplicationStatement(this.applicationStatement);
        }
        return this.realStatement;
    }

    public PreparedStatement getRealPreparedStatement() throws SQLException {
        if (this.applicationConnection == this.xaConnection.currentConnectionHandle) {
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realPreparedStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            PreparedStatement preparedStatement = ((BrokeredPreparedStatement)this.applicationStatement).createDuplicateStatement((Connection)this.xaConnection.realConnection, this.realPreparedStatement);
            ((EmbedPreparedStatement)this.realPreparedStatement).transferParameters((EmbedPreparedStatement)preparedStatement);
            try {
                this.realPreparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realPreparedStatement = preparedStatement;
            this.realConnection = this.xaConnection.realConnection;
            ((EmbedStatement)((Object)this.realPreparedStatement)).setApplicationStatement(this.applicationStatement);
        }
        return this.realPreparedStatement;
    }

    public CallableStatement getRealCallableStatement() throws SQLException {
        if (this.applicationConnection == this.xaConnection.currentConnectionHandle) {
            if (this.realConnection == this.xaConnection.realConnection) {
                return this.realCallableStatement;
            }
            if (this.xaConnection.realConnection == null) {
                this.xaConnection.getRealConnection();
            }
            CallableStatement callableStatement = ((BrokeredCallableStatement)this.applicationStatement).createDuplicateStatement((Connection)this.xaConnection.realConnection, this.realCallableStatement);
            ((EmbedStatement)((Object)this.realCallableStatement)).transferBatch((EmbedStatement)((Object)callableStatement));
            try {
                this.realCallableStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.realCallableStatement = callableStatement;
            this.realConnection = this.xaConnection.realConnection;
            ((EmbedStatement)((Object)this.realCallableStatement)).setApplicationStatement(this.applicationStatement);
        }
        return this.realCallableStatement;
    }

    public ResultSet wrapResultSet(Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            ((EmbedResultSet)resultSet).setApplicationStatement(statement);
        }
        return resultSet;
    }

    public int checkHoldCursors(int n) throws SQLException {
        return this.xaConnection.checkHoldCursors(n, true);
    }

    public ExceptionFactory getExceptionFactory() {
        return this.applicationConnection.getExceptionFactory();
    }
}

