/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.request;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class KrbIdentity {
    private PrincipalName principal;
    private int keyVersion = 1;
    private int kdcFlags = 0;
    private boolean disabled;
    private boolean locked;
    private KerberosTime expireTime = KerberosTime.NEVER;
    private KerberosTime createdTime = KerberosTime.now();
    private final Map<EncryptionType, EncryptionKey> keys = new HashMap<EncryptionType, EncryptionKey>();

    public KrbIdentity(String principalName) {
        this.principal = new PrincipalName(principalName);
    }

    public KrbIdentity(PrincipalName principalName) {
        this.principal = principalName;
    }

    public String getPrincipalName() {
        return this.principal.getName();
    }

    public void setPrincipalName(String newPrincipalName) {
        this.principal = new PrincipalName(newPrincipalName);
    }

    public void setPrincipalName(PrincipalName newPrincipalName) {
        this.principal = newPrincipalName;
    }

    public PrincipalName getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PrincipalName principal) {
        this.principal = principal;
    }

    public KerberosTime getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(KerberosTime expireTime) {
        this.expireTime = expireTime;
    }

    public KerberosTime getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(KerberosTime createdTime) {
        this.createdTime = createdTime;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void addKey(EncryptionKey encKey) {
        this.keys.put(encKey.getKeyType(), encKey);
    }

    public void addKeys(List<EncryptionKey> encKeys) {
        for (EncryptionKey key : encKeys) {
            this.keys.put(key.getKeyType(), key);
        }
    }

    public Map<EncryptionType, EncryptionKey> getKeys() {
        return this.keys;
    }

    public EncryptionKey getKey(EncryptionType encType) {
        return this.keys.get(encType);
    }

    public int getKdcFlags() {
        return this.kdcFlags;
    }

    public void setKdcFlags(int kdcFlags) {
        this.kdcFlags = kdcFlags;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public void setKeyVersion(int keyVersion) {
        this.keyVersion = keyVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof KrbIdentity) {
            KrbIdentity other = (KrbIdentity)obj;
            return !(this.principal == null ? other.principal != null : !this.principal.equals((Object)other.principal));
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        return result;
    }
}

