/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface SchemaMetaMapper {
    public static final String TABLE_NAME = "schema_meta";

    @Select(value={"SELECT schema_id as schemaId, schema_name as schemaName, metalake_id as metalakeId, catalog_id as catalogId, schema_comment as schemaComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM schema_meta WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public List<SchemaPO> listSchemaPOsByCatalogId(@Param(value="catalogId") Long var1);

    @Select(value={"SELECT schema_id as schemaId FROM schema_meta WHERE catalog_id = #{catalogId} AND schema_name = #{schemaName} AND deleted_at = 0"})
    public Long selectSchemaIdByCatalogIdAndName(@Param(value="catalogId") Long var1, @Param(value="schemaName") String var2);

    @Select(value={"SELECT schema_id as schemaId, schema_name as schemaName, metalake_id as metalakeId, catalog_id as catalogId, schema_comment as schemaComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM schema_meta WHERE catalog_id = #{catalogId} AND schema_name = #{schemaName} AND deleted_at = 0"})
    public SchemaPO selectSchemaMetaByCatalogIdAndName(@Param(value="catalogId") Long var1, @Param(value="schemaName") String var2);

    @Select(value={"SELECT schema_id as schemaId, schema_name as schemaName, metalake_id as metalakeId, catalog_id as catalogId, schema_comment as schemaComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM schema_meta WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public SchemaPO selectSchemaMetaById(@Param(value="schemaId") Long var1);

    @Insert(value={"INSERT INTO schema_meta(schema_id, schema_name, metalake_id, catalog_id, schema_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{schemaMeta.schemaId}, #{schemaMeta.schemaName}, #{schemaMeta.metalakeId}, #{schemaMeta.catalogId}, #{schemaMeta.schemaComment}, #{schemaMeta.properties}, #{schemaMeta.auditInfo}, #{schemaMeta.currentVersion}, #{schemaMeta.lastVersion}, #{schemaMeta.deletedAt} )"})
    public void insertSchemaMeta(@Param(value="schemaMeta") SchemaPO var1);

    @Insert(value={"INSERT INTO schema_meta(schema_id, schema_name, metalake_id, catalog_id, schema_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{schemaMeta.schemaId}, #{schemaMeta.schemaName}, #{schemaMeta.metalakeId}, #{schemaMeta.catalogId}, #{schemaMeta.schemaComment}, #{schemaMeta.properties}, #{schemaMeta.auditInfo}, #{schemaMeta.currentVersion}, #{schemaMeta.lastVersion}, #{schemaMeta.deletedAt} ) ON DUPLICATE KEY UPDATE schema_name = #{schemaMeta.schemaName}, metalake_id = #{schemaMeta.metalakeId}, catalog_id = #{schemaMeta.catalogId}, schema_comment = #{schemaMeta.schemaComment}, properties = #{schemaMeta.properties}, audit_info = #{schemaMeta.auditInfo}, current_version = #{schemaMeta.currentVersion}, last_version = #{schemaMeta.lastVersion}, deleted_at = #{schemaMeta.deletedAt}"})
    public void insertSchemaMetaOnDuplicateKeyUpdate(@Param(value="schemaMeta") SchemaPO var1);

    @Update(value={"UPDATE schema_meta SET schema_name = #{newSchemaMeta.schemaName}, metalake_id = #{newSchemaMeta.metalakeId}, catalog_id = #{newSchemaMeta.catalogId}, schema_comment = #{newSchemaMeta.schemaComment}, properties = #{newSchemaMeta.properties}, audit_info = #{newSchemaMeta.auditInfo}, current_version = #{newSchemaMeta.currentVersion}, last_version = #{newSchemaMeta.lastVersion}, deleted_at = #{newSchemaMeta.deletedAt} WHERE schema_id = #{oldSchemaMeta.schemaId} AND schema_name = #{oldSchemaMeta.schemaName} AND metalake_id = #{oldSchemaMeta.metalakeId} AND catalog_id = #{oldSchemaMeta.catalogId} AND (schema_comment IS NULL OR schema_comment = #{oldSchemaMeta.schemaComment}) AND properties = #{oldSchemaMeta.properties} AND audit_info = #{oldSchemaMeta.auditInfo} AND current_version = #{oldSchemaMeta.currentVersion} AND last_version = #{oldSchemaMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateSchemaMeta(@Param(value="newSchemaMeta") SchemaPO var1, @Param(value="oldSchemaMeta") SchemaPO var2);

    @Update(value={"UPDATE schema_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public Integer softDeleteSchemaMetasBySchemaId(@Param(value="schemaId") Long var1);

    @Update(value={"UPDATE schema_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public Integer softDeleteSchemaMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE schema_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public Integer softDeleteSchemaMetasByCatalogId(@Param(value="catalogId") Long var1);

    @Delete(value={"DELETE FROM schema_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteSchemaMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

