/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.RolePO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface RoleMetaMapper {
    public static final String ROLE_TABLE_NAME = "role_meta";
    public static final String USER_ROLE_RELATION_TABLE_NAME = "user_role_rel";
    public static final String GROUP_ROLE_RELATION_TABLE_NAME = "group_role_rel";

    @Select(value={"SELECT role_id as roleId, role_name as roleName, metalake_id as metalakeId, properties as properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM role_meta WHERE metalake_id = #{metalakeId} AND role_name = #{roleName} AND deleted_at = 0"})
    public RolePO selectRoleMetaByMetalakeIdAndName(@Param(value="metalakeId") Long var1, @Param(value="roleName") String var2);

    @Select(value={"SELECT role_id as roleId FROM role_meta WHERE metalake_id = #{metalakeId} AND role_name = #{roleName} AND deleted_at = 0"})
    public Long selectRoleIdByMetalakeIdAndName(@Param(value="metalakeId") Long var1, @Param(value="roleName") String var2);

    @Select(value={"SELECT ro.role_id as roleId, ro.role_name as roleName, ro.metalake_id as metalakeId, ro.properties as properties, ro.audit_info as auditInfo, ro.current_version as currentVersion, ro.last_version as lastVersion, ro.deleted_at as deletedAt FROM role_meta ro JOIN user_role_rel re ON ro.role_id = re.role_id WHERE re.user_id = #{userId} AND ro.deleted_at = 0 AND re.deleted_at = 0"})
    public List<RolePO> listRolesByUserId(@Param(value="userId") Long var1);

    @Select(value={"SELECT ro.role_id as roleId, ro.role_name as roleName, ro.metalake_id as metalakeId, ro.properties as properties, ro.audit_info as auditInfo, ro.current_version as currentVersion, ro.last_version as lastVersion, ro.deleted_at as deletedAt FROM role_meta ro JOIN group_role_rel ge ON ro.role_id = ge.role_id WHERE ge.group_id = #{groupId} AND ro.deleted_at = 0 AND ge.deleted_at = 0"})
    public List<RolePO> listRolesByGroupId(Long var1);

    @Select(value={"SELECT DISTINCT ro.role_id as roleId, ro.role_name as roleName, ro.metalake_id as metalakeId, ro.properties as properties, ro.audit_info as auditInfo, ro.current_version as currentVersion, ro.last_version as lastVersion, ro.deleted_at as deletedAt FROM role_meta ro JOIN role_meta_securable_object se ON ro.role_id = se.role_id WHERE se.metadata_object_id = #{metadataObjectId} AND se.type = #{metadataObjectType} AND ro.deleted_at = 0 AND se.deleted_at = 0"})
    public List<RolePO> listRolesByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long var1, @Param(value="metadataObjectType") String var2);

    @Insert(value={"INSERT INTO role_meta(role_id, role_name, metalake_id, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{roleMeta.roleId}, #{roleMeta.roleName}, #{roleMeta.metalakeId}, #{roleMeta.properties}, #{roleMeta.auditInfo}, #{roleMeta.currentVersion}, #{roleMeta.lastVersion}, #{roleMeta.deletedAt} )"})
    public void insertRoleMeta(@Param(value="roleMeta") RolePO var1);

    @Insert(value={"INSERT INTO role_meta(role_id, role_name, metalake_id, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{roleMeta.roleId}, #{roleMeta.roleName}, #{roleMeta.metalakeId}, #{roleMeta.properties}, #{roleMeta.auditInfo}, #{roleMeta.currentVersion}, #{roleMeta.lastVersion}, #{roleMeta.deletedAt} ) ON DUPLICATE KEY UPDATE role_name = #{roleMeta.roleName}, metalake_id = #{roleMeta.metalakeId}, properties = #{roleMeta.properties}, audit_info = #{roleMeta.auditInfo}, current_version = #{roleMeta.currentVersion}, last_version = #{roleMeta.lastVersion}, deleted_at = #{roleMeta.deletedAt}"})
    public void insertRoleMetaOnDuplicateKeyUpdate(@Param(value="roleMeta") RolePO var1);

    @Update(value={"UPDATE role_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE role_id = #{roleId} AND deleted_at = 0"})
    public void softDeleteRoleMetaByRoleId(Long var1);

    @Update(value={"UPDATE role_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public void softDeleteRoleMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Delete(value={"DELETE FROM role_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteRoleMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

