/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.trie;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bifromq.dist.trie.TopicFilterTrieNode;
import org.apache.bifromq.dist.trie.TopicTrieNode;

final class MTopicFilterTrieNode<V>
extends TopicFilterTrieNode<V> {
    private static final ConcurrentLinkedDeque<Long> KEYS = new ConcurrentLinkedDeque();
    private static final AtomicLong SEQ = new AtomicLong();
    private static volatile Ticker TICKER = Ticker.systemTicker();
    private static final Cache<Long, MTopicFilterTrieNode<?>> POOL = Caffeine.newBuilder().expireAfterAccess(EXPIRE_AFTER).recordStats().scheduler(Scheduler.systemScheduler()).ticker(() -> TICKER.read()).removalListener((key, value, cause) -> {
        KEYS.remove(key);
        if (cause == RemovalCause.EXPIRED || cause == RemovalCause.SIZE) {
            value.recycle();
        }
    }).build();
    private final Set<TopicTrieNode<V>> backingTopics = new HashSet<TopicTrieNode<V>>();

    MTopicFilterTrieNode() {
    }

    static <V> MTopicFilterTrieNode<V> borrow(TopicFilterTrieNode<V> parent, Set<TopicTrieNode<V>> siblingTopicTrieNodes) {
        Long key;
        while ((key = KEYS.pollFirst()) != null) {
            MTopicFilterTrieNode pooled = (MTopicFilterTrieNode)POOL.asMap().remove(key);
            if (pooled == null) continue;
            return pooled.init(parent, siblingTopicTrieNodes);
        }
        MTopicFilterTrieNode<V> node = new MTopicFilterTrieNode<V>();
        return node.init(parent, siblingTopicTrieNodes);
    }

    static void release(MTopicFilterTrieNode<?> node) {
        node.recycle();
        long key = SEQ.incrementAndGet();
        KEYS.offerLast(key);
        POOL.put((Object)key, node);
    }

    static void poolClear() {
        POOL.invalidateAll();
        POOL.cleanUp();
        KEYS.clear();
    }

    static void poolCleanUp() {
        POOL.cleanUp();
    }

    static int poolApproxSize() {
        return KEYS.size();
    }

    static void setTicker(Ticker ticker) {
        TICKER = ticker != null ? ticker : Ticker.systemTicker();
    }

    MTopicFilterTrieNode<V> init(TopicFilterTrieNode<V> parent, Set<TopicTrieNode<V>> siblingTopicTrieNodes) {
        assert (siblingTopicTrieNodes != null);
        this.parent = parent;
        this.backingTopics.clear();
        if (parent != null) {
            this.backingTopics.addAll(parent.backingTopics());
        }
        for (TopicTrieNode<V> sibling : siblingTopicTrieNodes) {
            this.collectTopics(sibling);
        }
        return this;
    }

    @Override
    String levelName() {
        return "#";
    }

    @Override
    Set<TopicTrieNode<V>> backingTopics() {
        return this.backingTopics;
    }

    private void collectTopics(TopicTrieNode<V> node) {
        if (node.isUserTopic()) {
            this.backingTopics.add(node);
        }
        for (TopicTrieNode child : node.children().values()) {
            this.collectTopics(child);
        }
    }

    @Override
    void seekChild(String childLevelName) {
    }

    @Override
    void seekPrevChild(String childLevelName) {
    }

    @Override
    void seekToFirstChild() {
    }

    @Override
    void seekToLastChild() {
    }

    @Override
    boolean atValidChild() {
        return false;
    }

    @Override
    void nextChild() {
    }

    @Override
    void prevChild() {
    }

    @Override
    TopicFilterTrieNode<V> childNode() {
        throw new NoSuchElementException();
    }

    private void recycle() {
        this.parent = null;
        this.backingTopics.clear();
    }
}

