/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.service;

import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.baseenv.MemUsage;
import org.apache.bifromq.baserpc.server.ResponsePipeline;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteRequest;
import org.apache.bifromq.mqtt.service.ILocalDistService;
import org.apache.bifromq.sysprops.props.IngressSlowDownDirectMemoryUsage;
import org.apache.bifromq.sysprops.props.IngressSlowDownHeapMemoryUsage;
import org.apache.bifromq.sysprops.props.MaxSlowDownTimeoutSeconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalSessionWritePipeline
extends ResponsePipeline<WriteRequest, WriteReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalSessionWritePipeline.class);
    private static final double SLOWDOWN_DIRECT_MEM_USAGE = (Double)IngressSlowDownDirectMemoryUsage.INSTANCE.get();
    private static final double SLOWDOWN_HEAP_MEM_USAGE = (Double)IngressSlowDownHeapMemoryUsage.INSTANCE.get();
    private static final Duration SLOWDOWN_TIMEOUT = Duration.ofSeconds(((Integer)MaxSlowDownTimeoutSeconds.INSTANCE.get()).intValue());
    private final ILocalDistService localDistService;

    public LocalSessionWritePipeline(ILocalDistService localDistService, StreamObserver<WriteReply> responseObserver) {
        super(responseObserver, () -> MemUsage.local().nettyDirectMemoryUsage() > SLOWDOWN_DIRECT_MEM_USAGE || MemUsage.local().heapMemoryUsage() > SLOWDOWN_HEAP_MEM_USAGE, SLOWDOWN_TIMEOUT);
        this.localDistService = localDistService;
    }

    protected CompletableFuture<WriteReply> handleRequest(String tenantId, WriteRequest request) {
        log.trace("Handle inbox write request: \n{}", (Object)request);
        return this.localDistService.dist(request.getRequest()).thenApply(reply -> WriteReply.newBuilder().setReqId(request.getReqId()).setReply(reply).build());
    }
}

