/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import lombok.Generated;
import org.apache.bifromq.basecrdt.store.CompressAlgorithm;
import org.apache.bifromq.baseenv.EnvProvider;

public class CRDTStoreOptions {
    private String id;
    private int maxEventsInDelta;
    private CompressAlgorithm compressAlgorithm;
    private Duration orHistoryExpireTime;
    private Duration inflationInterval;
    private Duration maxCompactionTime;
    private ScheduledExecutorService storeExecutor;

    @Generated
    private static String $default$id() {
        return UUID.randomUUID().toString();
    }

    @Generated
    private static int $default$maxEventsInDelta() {
        return 1024;
    }

    @Generated
    private static CompressAlgorithm $default$compressAlgorithm() {
        return CompressAlgorithm.GZIP;
    }

    @Generated
    private static Duration $default$orHistoryExpireTime() {
        return Duration.ofSeconds(20L);
    }

    @Generated
    private static Duration $default$inflationInterval() {
        return Duration.ofMillis(200L);
    }

    @Generated
    private static Duration $default$maxCompactionTime() {
        return Duration.ofMillis(200L);
    }

    @Generated
    private static ScheduledExecutorService $default$storeExecutor() {
        return new ScheduledThreadPoolExecutor(Math.max(2, EnvProvider.INSTANCE.availableProcessors() / 20), EnvProvider.INSTANCE.newThreadFactory("crdt-executor", true));
    }

    @Generated
    public static CRDTStoreOptionsBuilder builder() {
        return new CRDTStoreOptionsBuilder();
    }

    @Generated
    public CRDTStoreOptionsBuilder toBuilder() {
        return new CRDTStoreOptionsBuilder().id(this.id).maxEventsInDelta(this.maxEventsInDelta).compressAlgorithm(this.compressAlgorithm).orHistoryExpireTime(this.orHistoryExpireTime).inflationInterval(this.inflationInterval).maxCompactionTime(this.maxCompactionTime).storeExecutor(this.storeExecutor);
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public int maxEventsInDelta() {
        return this.maxEventsInDelta;
    }

    @Generated
    public CompressAlgorithm compressAlgorithm() {
        return this.compressAlgorithm;
    }

    @Generated
    public Duration orHistoryExpireTime() {
        return this.orHistoryExpireTime;
    }

    @Generated
    public Duration inflationInterval() {
        return this.inflationInterval;
    }

    @Generated
    public Duration maxCompactionTime() {
        return this.maxCompactionTime;
    }

    @Generated
    public ScheduledExecutorService storeExecutor() {
        return this.storeExecutor;
    }

    @Generated
    public CRDTStoreOptions id(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public CRDTStoreOptions maxEventsInDelta(int maxEventsInDelta) {
        this.maxEventsInDelta = maxEventsInDelta;
        return this;
    }

    @Generated
    public CRDTStoreOptions compressAlgorithm(CompressAlgorithm compressAlgorithm) {
        this.compressAlgorithm = compressAlgorithm;
        return this;
    }

    @Generated
    public CRDTStoreOptions orHistoryExpireTime(Duration orHistoryExpireTime) {
        this.orHistoryExpireTime = orHistoryExpireTime;
        return this;
    }

    @Generated
    public CRDTStoreOptions inflationInterval(Duration inflationInterval) {
        this.inflationInterval = inflationInterval;
        return this;
    }

    @Generated
    public CRDTStoreOptions maxCompactionTime(Duration maxCompactionTime) {
        this.maxCompactionTime = maxCompactionTime;
        return this;
    }

    @Generated
    public CRDTStoreOptions storeExecutor(ScheduledExecutorService storeExecutor) {
        this.storeExecutor = storeExecutor;
        return this;
    }

    @Generated
    public CRDTStoreOptions() {
        this.id = CRDTStoreOptions.$default$id();
        this.maxEventsInDelta = CRDTStoreOptions.$default$maxEventsInDelta();
        this.compressAlgorithm = CRDTStoreOptions.$default$compressAlgorithm();
        this.orHistoryExpireTime = CRDTStoreOptions.$default$orHistoryExpireTime();
        this.inflationInterval = CRDTStoreOptions.$default$inflationInterval();
        this.maxCompactionTime = CRDTStoreOptions.$default$maxCompactionTime();
        this.storeExecutor = CRDTStoreOptions.$default$storeExecutor();
    }

    @Generated
    private CRDTStoreOptions(String id, int maxEventsInDelta, CompressAlgorithm compressAlgorithm, Duration orHistoryExpireTime, Duration inflationInterval, Duration maxCompactionTime, ScheduledExecutorService storeExecutor) {
        this.id = id;
        this.maxEventsInDelta = maxEventsInDelta;
        this.compressAlgorithm = compressAlgorithm;
        this.orHistoryExpireTime = orHistoryExpireTime;
        this.inflationInterval = inflationInterval;
        this.maxCompactionTime = maxCompactionTime;
        this.storeExecutor = storeExecutor;
    }

    @Generated
    public static class CRDTStoreOptionsBuilder {
        @Generated
        private boolean id$set;
        @Generated
        private String id$value;
        @Generated
        private boolean maxEventsInDelta$set;
        @Generated
        private int maxEventsInDelta$value;
        @Generated
        private boolean compressAlgorithm$set;
        @Generated
        private CompressAlgorithm compressAlgorithm$value;
        @Generated
        private boolean orHistoryExpireTime$set;
        @Generated
        private Duration orHistoryExpireTime$value;
        @Generated
        private boolean inflationInterval$set;
        @Generated
        private Duration inflationInterval$value;
        @Generated
        private boolean maxCompactionTime$set;
        @Generated
        private Duration maxCompactionTime$value;
        @Generated
        private boolean storeExecutor$set;
        @Generated
        private ScheduledExecutorService storeExecutor$value;

        @Generated
        CRDTStoreOptionsBuilder() {
        }

        @Generated
        public CRDTStoreOptionsBuilder id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @Generated
        public CRDTStoreOptionsBuilder maxEventsInDelta(int maxEventsInDelta) {
            this.maxEventsInDelta$value = maxEventsInDelta;
            this.maxEventsInDelta$set = true;
            return this;
        }

        @Generated
        public CRDTStoreOptionsBuilder compressAlgorithm(CompressAlgorithm compressAlgorithm) {
            this.compressAlgorithm$value = compressAlgorithm;
            this.compressAlgorithm$set = true;
            return this;
        }

        @Generated
        public CRDTStoreOptionsBuilder orHistoryExpireTime(Duration orHistoryExpireTime) {
            this.orHistoryExpireTime$value = orHistoryExpireTime;
            this.orHistoryExpireTime$set = true;
            return this;
        }

        @Generated
        public CRDTStoreOptionsBuilder inflationInterval(Duration inflationInterval) {
            this.inflationInterval$value = inflationInterval;
            this.inflationInterval$set = true;
            return this;
        }

        @Generated
        public CRDTStoreOptionsBuilder maxCompactionTime(Duration maxCompactionTime) {
            this.maxCompactionTime$value = maxCompactionTime;
            this.maxCompactionTime$set = true;
            return this;
        }

        @Generated
        public CRDTStoreOptionsBuilder storeExecutor(ScheduledExecutorService storeExecutor) {
            this.storeExecutor$value = storeExecutor;
            this.storeExecutor$set = true;
            return this;
        }

        @Generated
        public CRDTStoreOptions build() {
            String id$value = this.id$value;
            if (!this.id$set) {
                id$value = CRDTStoreOptions.$default$id();
            }
            int maxEventsInDelta$value = this.maxEventsInDelta$value;
            if (!this.maxEventsInDelta$set) {
                maxEventsInDelta$value = CRDTStoreOptions.$default$maxEventsInDelta();
            }
            CompressAlgorithm compressAlgorithm$value = this.compressAlgorithm$value;
            if (!this.compressAlgorithm$set) {
                compressAlgorithm$value = CRDTStoreOptions.$default$compressAlgorithm();
            }
            Duration orHistoryExpireTime$value = this.orHistoryExpireTime$value;
            if (!this.orHistoryExpireTime$set) {
                orHistoryExpireTime$value = CRDTStoreOptions.$default$orHistoryExpireTime();
            }
            Duration inflationInterval$value = this.inflationInterval$value;
            if (!this.inflationInterval$set) {
                inflationInterval$value = CRDTStoreOptions.$default$inflationInterval();
            }
            Duration maxCompactionTime$value = this.maxCompactionTime$value;
            if (!this.maxCompactionTime$set) {
                maxCompactionTime$value = CRDTStoreOptions.$default$maxCompactionTime();
            }
            ScheduledExecutorService storeExecutor$value = this.storeExecutor$value;
            if (!this.storeExecutor$set) {
                storeExecutor$value = CRDTStoreOptions.$default$storeExecutor();
            }
            return new CRDTStoreOptions(id$value, maxEventsInDelta$value, compressAlgorithm$value, orHistoryExpireTime$value, inflationInterval$value, maxCompactionTime$value, storeExecutor$value);
        }

        @Generated
        public String toString() {
            return "CRDTStoreOptions.CRDTStoreOptionsBuilder(id$value=" + this.id$value + ", maxEventsInDelta$value=" + this.maxEventsInDelta$value + ", compressAlgorithm$value=" + String.valueOf((Object)this.compressAlgorithm$value) + ", orHistoryExpireTime$value=" + String.valueOf(this.orHistoryExpireTime$value) + ", inflationInterval$value=" + String.valueOf(this.inflationInterval$value) + ", maxCompactionTime$value=" + String.valueOf(this.maxCompactionTime$value) + ", storeExecutor$value=" + String.valueOf(this.storeExecutor$value) + ")";
        }
    }
}

