/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.option;

import com.google.protobuf.Struct;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.spi.IKVEngineProvider;
import org.apache.bifromq.basekv.store.option.KVRangeOptions;
import org.apache.bifromq.basekv.store.util.ProcessUtil;

public class KVRangeStoreOptions {
    private String overrideIdentity;
    private KVRangeOptions kvRangeOptions;
    private int statsCollectIntervalSec;
    private String dataEngineType;
    private Struct dataEngineConf;
    private String walEngineType;
    private Struct walEngineConf;
    private Map<String, Struct> splitHinterFactoryConfig;

    private static Struct defaultDataConf() {
        IKVEngineProvider provider = KVRangeStoreOptions.findProvider("rocksdb");
        Struct.Builder b = provider.defaultsForCPable().toBuilder();
        String dbRoot = Paths.get(System.getProperty("java.io.tmpdir"), "basekv", ProcessUtil.processId(), "data").toString();
        String cpRoot = Paths.get(System.getProperty("java.io.tmpdir"), "basekvcp", ProcessUtil.processId(), "data").toString();
        b.putFields("dbRootDir", StructUtil.toValue((Object)dbRoot));
        b.putFields("dbCheckpointRootDir", StructUtil.toValue((Object)cpRoot));
        return b.build();
    }

    private static Struct defaultWalConf() {
        IKVEngineProvider provider = KVRangeStoreOptions.findProvider("rocksdb");
        Struct.Builder b = provider.defaultsForWALable().toBuilder();
        String dbRoot = Paths.get(System.getProperty("java.io.tmpdir"), "basekv", ProcessUtil.processId(), "wal").toString();
        b.putFields("dbRootDir", StructUtil.toValue((Object)dbRoot));
        return b.build();
    }

    private static IKVEngineProvider findProvider(String type) {
        Map providers = BaseHookLoader.load(IKVEngineProvider.class);
        for (IKVEngineProvider p : providers.values()) {
            if (!p.type().equalsIgnoreCase(type)) continue;
            return p;
        }
        throw new IllegalArgumentException("Unsupported storage engine type: " + type);
    }

    @Generated
    private static KVRangeOptions $default$kvRangeOptions() {
        return new KVRangeOptions();
    }

    @Generated
    private static int $default$statsCollectIntervalSec() {
        return 5;
    }

    @Generated
    private static String $default$dataEngineType() {
        return "rocksdb";
    }

    @Generated
    private static Struct $default$dataEngineConf() {
        return KVRangeStoreOptions.defaultDataConf();
    }

    @Generated
    private static String $default$walEngineType() {
        return "rocksdb";
    }

    @Generated
    private static Struct $default$walEngineConf() {
        return KVRangeStoreOptions.defaultWalConf();
    }

    @Generated
    private static Map<String, Struct> $default$splitHinterFactoryConfig() {
        return new HashMap<String, Struct>();
    }

    @Generated
    public static KVRangeStoreOptionsBuilder builder() {
        return new KVRangeStoreOptionsBuilder();
    }

    @Generated
    public KVRangeStoreOptionsBuilder toBuilder() {
        return new KVRangeStoreOptionsBuilder().overrideIdentity(this.overrideIdentity).kvRangeOptions(this.kvRangeOptions).statsCollectIntervalSec(this.statsCollectIntervalSec).dataEngineType(this.dataEngineType).dataEngineConf(this.dataEngineConf).walEngineType(this.walEngineType).walEngineConf(this.walEngineConf).splitHinterFactoryConfig(this.splitHinterFactoryConfig);
    }

    @Generated
    public String getOverrideIdentity() {
        return this.overrideIdentity;
    }

    @Generated
    public KVRangeOptions getKvRangeOptions() {
        return this.kvRangeOptions;
    }

    @Generated
    public int getStatsCollectIntervalSec() {
        return this.statsCollectIntervalSec;
    }

    @Generated
    public String getDataEngineType() {
        return this.dataEngineType;
    }

    @Generated
    public Struct getDataEngineConf() {
        return this.dataEngineConf;
    }

    @Generated
    public String getWalEngineType() {
        return this.walEngineType;
    }

    @Generated
    public Struct getWalEngineConf() {
        return this.walEngineConf;
    }

    @Generated
    public Map<String, Struct> getSplitHinterFactoryConfig() {
        return this.splitHinterFactoryConfig;
    }

    @Generated
    public KVRangeStoreOptions setOverrideIdentity(String overrideIdentity) {
        this.overrideIdentity = overrideIdentity;
        return this;
    }

    @Generated
    public KVRangeStoreOptions setKvRangeOptions(KVRangeOptions kvRangeOptions) {
        this.kvRangeOptions = kvRangeOptions;
        return this;
    }

    @Generated
    public KVRangeStoreOptions setStatsCollectIntervalSec(int statsCollectIntervalSec) {
        this.statsCollectIntervalSec = statsCollectIntervalSec;
        return this;
    }

    @Generated
    public KVRangeStoreOptions setDataEngineType(String dataEngineType) {
        this.dataEngineType = dataEngineType;
        return this;
    }

    @Generated
    public KVRangeStoreOptions setDataEngineConf(Struct dataEngineConf) {
        this.dataEngineConf = dataEngineConf;
        return this;
    }

    @Generated
    public KVRangeStoreOptions setWalEngineType(String walEngineType) {
        this.walEngineType = walEngineType;
        return this;
    }

    @Generated
    public KVRangeStoreOptions setWalEngineConf(Struct walEngineConf) {
        this.walEngineConf = walEngineConf;
        return this;
    }

    @Generated
    public KVRangeStoreOptions setSplitHinterFactoryConfig(Map<String, Struct> splitHinterFactoryConfig) {
        this.splitHinterFactoryConfig = splitHinterFactoryConfig;
        return this;
    }

    @Generated
    public String toString() {
        return "KVRangeStoreOptions(overrideIdentity=" + this.getOverrideIdentity() + ", kvRangeOptions=" + String.valueOf(this.getKvRangeOptions()) + ", statsCollectIntervalSec=" + this.getStatsCollectIntervalSec() + ", dataEngineType=" + this.getDataEngineType() + ", dataEngineConf=" + String.valueOf(this.getDataEngineConf()) + ", walEngineType=" + this.getWalEngineType() + ", walEngineConf=" + String.valueOf(this.getWalEngineConf()) + ", splitHinterFactoryConfig=" + String.valueOf(this.getSplitHinterFactoryConfig()) + ")";
    }

    @Generated
    public KVRangeStoreOptions() {
        this.kvRangeOptions = KVRangeStoreOptions.$default$kvRangeOptions();
        this.statsCollectIntervalSec = KVRangeStoreOptions.$default$statsCollectIntervalSec();
        this.dataEngineType = KVRangeStoreOptions.$default$dataEngineType();
        this.dataEngineConf = KVRangeStoreOptions.$default$dataEngineConf();
        this.walEngineType = KVRangeStoreOptions.$default$walEngineType();
        this.walEngineConf = KVRangeStoreOptions.$default$walEngineConf();
        this.splitHinterFactoryConfig = KVRangeStoreOptions.$default$splitHinterFactoryConfig();
    }

    @Generated
    private KVRangeStoreOptions(String overrideIdentity, KVRangeOptions kvRangeOptions, int statsCollectIntervalSec, String dataEngineType, Struct dataEngineConf, String walEngineType, Struct walEngineConf, Map<String, Struct> splitHinterFactoryConfig) {
        this.overrideIdentity = overrideIdentity;
        this.kvRangeOptions = kvRangeOptions;
        this.statsCollectIntervalSec = statsCollectIntervalSec;
        this.dataEngineType = dataEngineType;
        this.dataEngineConf = dataEngineConf;
        this.walEngineType = walEngineType;
        this.walEngineConf = walEngineConf;
        this.splitHinterFactoryConfig = splitHinterFactoryConfig;
    }

    @Generated
    public static class KVRangeStoreOptionsBuilder {
        @Generated
        private String overrideIdentity;
        @Generated
        private boolean kvRangeOptions$set;
        @Generated
        private KVRangeOptions kvRangeOptions$value;
        @Generated
        private boolean statsCollectIntervalSec$set;
        @Generated
        private int statsCollectIntervalSec$value;
        @Generated
        private boolean dataEngineType$set;
        @Generated
        private String dataEngineType$value;
        @Generated
        private boolean dataEngineConf$set;
        @Generated
        private Struct dataEngineConf$value;
        @Generated
        private boolean walEngineType$set;
        @Generated
        private String walEngineType$value;
        @Generated
        private boolean walEngineConf$set;
        @Generated
        private Struct walEngineConf$value;
        @Generated
        private boolean splitHinterFactoryConfig$set;
        @Generated
        private Map<String, Struct> splitHinterFactoryConfig$value;

        @Generated
        KVRangeStoreOptionsBuilder() {
        }

        @Generated
        public KVRangeStoreOptionsBuilder overrideIdentity(String overrideIdentity) {
            this.overrideIdentity = overrideIdentity;
            return this;
        }

        @Generated
        public KVRangeStoreOptionsBuilder kvRangeOptions(KVRangeOptions kvRangeOptions) {
            this.kvRangeOptions$value = kvRangeOptions;
            this.kvRangeOptions$set = true;
            return this;
        }

        @Generated
        public KVRangeStoreOptionsBuilder statsCollectIntervalSec(int statsCollectIntervalSec) {
            this.statsCollectIntervalSec$value = statsCollectIntervalSec;
            this.statsCollectIntervalSec$set = true;
            return this;
        }

        @Generated
        public KVRangeStoreOptionsBuilder dataEngineType(String dataEngineType) {
            this.dataEngineType$value = dataEngineType;
            this.dataEngineType$set = true;
            return this;
        }

        @Generated
        public KVRangeStoreOptionsBuilder dataEngineConf(Struct dataEngineConf) {
            this.dataEngineConf$value = dataEngineConf;
            this.dataEngineConf$set = true;
            return this;
        }

        @Generated
        public KVRangeStoreOptionsBuilder walEngineType(String walEngineType) {
            this.walEngineType$value = walEngineType;
            this.walEngineType$set = true;
            return this;
        }

        @Generated
        public KVRangeStoreOptionsBuilder walEngineConf(Struct walEngineConf) {
            this.walEngineConf$value = walEngineConf;
            this.walEngineConf$set = true;
            return this;
        }

        @Generated
        public KVRangeStoreOptionsBuilder splitHinterFactoryConfig(Map<String, Struct> splitHinterFactoryConfig) {
            this.splitHinterFactoryConfig$value = splitHinterFactoryConfig;
            this.splitHinterFactoryConfig$set = true;
            return this;
        }

        @Generated
        public KVRangeStoreOptions build() {
            KVRangeOptions kvRangeOptions$value = this.kvRangeOptions$value;
            if (!this.kvRangeOptions$set) {
                kvRangeOptions$value = KVRangeStoreOptions.$default$kvRangeOptions();
            }
            int statsCollectIntervalSec$value = this.statsCollectIntervalSec$value;
            if (!this.statsCollectIntervalSec$set) {
                statsCollectIntervalSec$value = KVRangeStoreOptions.$default$statsCollectIntervalSec();
            }
            String dataEngineType$value = this.dataEngineType$value;
            if (!this.dataEngineType$set) {
                dataEngineType$value = KVRangeStoreOptions.$default$dataEngineType();
            }
            Struct dataEngineConf$value = this.dataEngineConf$value;
            if (!this.dataEngineConf$set) {
                dataEngineConf$value = KVRangeStoreOptions.$default$dataEngineConf();
            }
            String walEngineType$value = this.walEngineType$value;
            if (!this.walEngineType$set) {
                walEngineType$value = KVRangeStoreOptions.$default$walEngineType();
            }
            Struct walEngineConf$value = this.walEngineConf$value;
            if (!this.walEngineConf$set) {
                walEngineConf$value = KVRangeStoreOptions.$default$walEngineConf();
            }
            Map<String, Struct> splitHinterFactoryConfig$value = this.splitHinterFactoryConfig$value;
            if (!this.splitHinterFactoryConfig$set) {
                splitHinterFactoryConfig$value = KVRangeStoreOptions.$default$splitHinterFactoryConfig();
            }
            return new KVRangeStoreOptions(this.overrideIdentity, kvRangeOptions$value, statsCollectIntervalSec$value, dataEngineType$value, dataEngineConf$value, walEngineType$value, walEngineConf$value, splitHinterFactoryConfig$value);
        }

        @Generated
        public String toString() {
            return "KVRangeStoreOptions.KVRangeStoreOptionsBuilder(overrideIdentity=" + this.overrideIdentity + ", kvRangeOptions$value=" + String.valueOf(this.kvRangeOptions$value) + ", statsCollectIntervalSec$value=" + this.statsCollectIntervalSec$value + ", dataEngineType$value=" + this.dataEngineType$value + ", dataEngineConf$value=" + String.valueOf(this.dataEngineConf$value) + ", walEngineType$value=" + this.walEngineType$value + ", walEngineConf$value=" + String.valueOf(this.walEngineConf$value) + ", splitHinterFactoryConfig$value=" + String.valueOf(this.splitHinterFactoryConfig$value) + ")";
        }
    }
}

