/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.IKVSpaceRefreshableReader;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.memory.AbstractInMemKVSpaceReader;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpace;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.slf4j.Logger;

class InMemKVSpaceReader
extends AbstractInMemKVSpaceReader
implements IKVSpaceRefreshableReader {
    private static final int MAX_CACHE_ENTRIES = 1024;
    private final ISyncContext.IRefresher refresher;
    private final Supplier<InMemKVSpaceEpoch> epochSupplier;
    private final InMemKVSpace.TrackedBoundaryIndex tracker;
    private final Set<InMemKVSpaceIterator> openedIterators = Sets.newConcurrentHashSet();
    private final Map<Boundary, Long> sizeCache = new ConcurrentSkipListMap<Boundary, Long>(BoundaryUtil::compare);
    private volatile InMemKVSpaceEpoch currentEpoch;

    InMemKVSpaceReader(String id, KVSpaceOpMeters readOpMeters, Logger logger, ISyncContext.IRefresher refresher, Supplier<InMemKVSpaceEpoch> epochSupplier, InMemKVSpace.TrackedBoundaryIndex tracker) {
        super(id, readOpMeters, logger);
        this.refresher = refresher;
        this.epochSupplier = epochSupplier;
        this.tracker = tracker;
        this.currentEpoch = epochSupplier.get();
    }

    @Override
    protected Map<ByteString, ByteString> metadataMap() {
        return this.currentEpoch.metadataMap();
    }

    @Override
    protected NavigableMap<ByteString, ByteString> rangeData() {
        return this.currentEpoch.dataMap();
    }

    public void close() {
    }

    public void refresh() {
        this.refresher.runIfNeeded(genBumped -> {
            this.currentEpoch = this.epochSupplier.get();
            this.sizeCache.clear();
            this.openedIterators.forEach(itr -> itr.refresh(this.currentEpoch.dataMap()));
        });
    }

    protected IKVSpaceIterator doNewIterator(Boundary subBoundary) {
        InMemKVSpaceIterator itr = new InMemKVSpaceIterator(this.rangeData(), subBoundary, this.openedIterators::remove);
        this.openedIterators.add(itr);
        return itr;
    }

    protected long doSize(Boundary boundary) {
        long sized;
        block6: {
            if (!boundary.hasStartKey() && !boundary.hasEndKey()) {
                return this.currentEpoch.totalDataBytes();
            }
            Long cached = this.sizeCache.get(boundary);
            if (cached != null) {
                return cached;
            }
            sized = this.tracker.sizeOrTrack(this.currentEpoch, boundary);
            if (this.sizeCache.size() >= 1024) {
                try {
                    ConcurrentSkipListMap sl = (ConcurrentSkipListMap)this.sizeCache;
                    if (sl.pollFirstEntry() == null && !this.sizeCache.isEmpty()) {
                        this.sizeCache.remove(this.sizeCache.keySet().iterator().next());
                    }
                }
                catch (ClassCastException ignored) {
                    if (this.sizeCache.isEmpty()) break block6;
                    this.sizeCache.remove(this.sizeCache.keySet().iterator().next());
                }
            }
        }
        this.sizeCache.put(boundary, sized);
        return sized;
    }
}

