/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.common.base.Strings;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import org.apache.bifromq.starter.config.model.ServerSSLContextConfig;
import org.apache.bifromq.starter.utils.ResourceUtil;

public class SSLUtil {
    public static SslProvider defaultSslProvider() {
        if (OpenSsl.isAvailable()) {
            return SslProvider.OPENSSL;
        }
        Provider jdkProvider = SSLUtil.findJdkProvider();
        if (jdkProvider != null) {
            return SslProvider.JDK;
        }
        throw new IllegalStateException("Could not find TLS provider");
    }

    public static Provider findJdkProvider() {
        Provider[] providers = Security.getProviders("SSLContext.TLS");
        if (providers.length > 0) {
            return providers[0];
        }
        return null;
    }

    public static SslContext buildServerSslContext(ServerSSLContextConfig config) {
        try {
            SslProvider sslProvider = SSLUtil.defaultSslProvider();
            SslContextBuilder sslCtxBuilder = SslContextBuilder.forServer((File)ResourceUtil.loadFile(config.getCertFile()), (File)ResourceUtil.loadFile(config.getKeyFile())).clientAuth(config.getClientAuth()).sslProvider(sslProvider);
            if (Strings.isNullOrEmpty((String)config.getTrustCertsFile())) {
                sslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else {
                sslCtxBuilder.trustManager(ResourceUtil.loadFile(config.getTrustCertsFile()));
            }
            if (sslProvider == SslProvider.JDK) {
                sslCtxBuilder.sslContextProvider(SSLUtil.findJdkProvider());
            }
            return sslCtxBuilder.build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Fail to initialize server SSLContext", e);
        }
    }
}

